/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.render;

import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.render.ShapeRenderer;
import edu.berkeley.guir.prefuse.util.GeometryLib;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class PolygonRenderer
extends ShapeRenderer {
    public static final int EDGE_LINE = 0;
    public static final int EDGE_CURVE = 1;
    private int edgeType = 0;
    private float controlFrac = 0.1f;

    public PolygonRenderer() {
        this(0);
    }

    public PolygonRenderer(int n) {
        this.edgeType = n;
    }

    public int getEdgeType() {
        return this.edgeType;
    }

    public void setEdgeType(int n) {
        this.edgeType = n;
    }

    protected Shape getRawShape(VisualItem visualItem) {
        float[] fArray = (float[])visualItem.getVizAttribute("polygon");
        float f = (float)visualItem.getX();
        float f2 = (float)visualItem.getY();
        if (this.edgeType == 0) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f + fArray[0], f2 + fArray[1]);
            for (int i = 2; i < fArray.length; i += 2) {
                generalPath.lineTo(f + fArray[i], f2 + fArray[i + 1]);
            }
            generalPath.closePath();
            return generalPath;
        }
        if (this.edgeType == 1) {
            GeneralPath generalPath = GeometryLib.cardinalSpline(fArray, 0.25f, true);
            if (f != 0.0f || f2 != 0.0f) {
                Shape shape = generalPath.createTransformedShape(AffineTransform.getTranslateInstance(f, f2));
                return shape;
            }
            return generalPath;
        }
        return null;
    }
}

