/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.util;

import edu.berkeley.guir.prefuse.util.ColorLib;
import java.awt.Color;
import java.awt.Paint;

public class ColorMap {
    public static final int DEFAULT_MAP_SIZE = 64;
    private Paint[] colorMap;
    private double minValue;
    private double maxValue;

    public ColorMap(Paint[] paintArray, double d, double d2) {
        this.colorMap = paintArray;
        this.minValue = d;
        this.maxValue = d2;
    }

    public Paint getColor(double d) {
        if (d < this.minValue) {
            return this.colorMap[0];
        }
        if (d > this.maxValue) {
            return this.colorMap[this.colorMap.length - 1];
        }
        int n = (int)Math.round((double)(this.colorMap.length - 1) * (d - this.minValue) / (this.maxValue - this.minValue));
        return this.colorMap[n];
    }

    public Paint[] getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(Paint[] paintArray) {
        this.colorMap = paintArray;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    public static Paint[] getGrayscaleMap() {
        return ColorMap.getGrayscaleMap(64);
    }

    public static Paint[] getGrayscaleMap(int n) {
        Paint[] paintArray = new Paint[n];
        for (int i = 0; i < n; ++i) {
            float f = (float)i / (float)(n - 1);
            paintArray[i] = ColorLib.getColor(f, f, f, 1.0f);
        }
        return paintArray;
    }

    public static Paint[] getInterpolatedMap(Color color, Color color2) {
        return ColorMap.getInterpolatedMap(64, color, color2);
    }

    public static Paint[] getInterpolatedMap(int n, Color color, Color color2) {
        Paint[] paintArray = new Paint[n];
        for (int i = 0; i < n; ++i) {
            float f = (float)i / (float)(n - 1);
            paintArray[i] = ColorLib.getIntermediateColor(color, color2, f);
        }
        return paintArray;
    }

    public static Paint[] getHSBMap() {
        return ColorMap.getHSBMap(64, 1.0f, 1.0f);
    }

    public static Paint[] getHSBMap(int n, float f, float f2) {
        Paint[] paintArray = new Paint[n];
        for (int i = 0; i < n; ++i) {
            float f3 = (float)i / (float)(n - 1);
            paintArray[i] = ColorLib.getColor(Color.HSBtoRGB(f3, f, f2));
        }
        return paintArray;
    }

    public static Paint[] getHotMap() {
        return ColorMap.getHotMap(64);
    }

    public static Paint[] getHotMap(int n) {
        Paint[] paintArray = new Paint[n];
        for (int i = 0; i < n; ++i) {
            float f;
            int n2 = 3 * n / 8;
            float f2 = f = i < n2 ? (float)(i + 1) / (float)n2 : 1.0f;
            float f3 = i < n2 ? 0.0f : (i < 2 * n2 ? (float)(i - n2) / (float)n2 : 1.0f);
            float f4 = i < 2 * n2 ? 0.0f : (float)(i - 2 * n2) / (float)(n - 2 * n2);
            paintArray[i] = ColorLib.getColor(f, f3, f4, 1.0f);
        }
        return paintArray;
    }

    public static Paint[] getCoolMap() {
        return ColorMap.getCoolMap(64);
    }

    public static Paint[] getCoolMap(int n) {
        Paint[] paintArray = new Paint[n];
        for (int i = 0; i < n; ++i) {
            float f = (float)i / Math.max((float)(n - 1), 1.0f);
            paintArray[i] = ColorLib.getColor(f, 1.0f - f, 1.0f, 1.0f);
        }
        return paintArray;
    }
}

