/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.util;

import edu.berkeley.guir.prefuse.FocusManager;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.event.ItemRegistryListener;
import edu.berkeley.guir.prefuse.focus.FocusSet;
import edu.berkeley.guir.prefuse.focus.PrefixSearchFocusSet;
import edu.berkeley.guir.prefuse.graph.Entity;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PrefixSearchPanel
extends JPanel
implements DocumentListener,
ActionListener {
    private ItemRegistry registry;
    private PrefixSearchFocusSet searcher;
    private FocusSet focus;
    private JTextField queryF = new JTextField(15);
    private JLabel resultL = new JLabel();
    private JLabel matchL = new JLabel();
    private JLabel searchL = new JLabel("search >> ");
    private IconButton upArrow = new IconButton(new ArrowIcon(0), new ArrowIcon(1));
    private IconButton downArrow = new IconButton(new ArrowIcon(2), new ArrowIcon(3));
    private String[] searchAttr;
    private Entity[] m_results;
    private int m_curResult;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PrefixSearchPanel(String[] stringArray, ItemRegistry itemRegistry) {
        this.searchAttr = stringArray;
        FocusManager focusManager = itemRegistry.getFocusManager();
        this.focus = focusManager.getDefaultFocusSet();
        FocusSet focusSet = itemRegistry.getFocusManager().getFocusSet("search");
        if (focusSet != null) {
            if (!(focusSet instanceof PrefixSearchFocusSet)) throw new IllegalStateException("Search focus set not instance of PrefixSearchFocusSet!");
            this.searcher = (PrefixSearchFocusSet)focusSet;
        } else {
            this.searcher = new PrefixSearchFocusSet();
            focusManager.putFocusSet("search", this.searcher);
        }
        this.init(itemRegistry);
    }

    public PrefixSearchPanel(String[] stringArray, ItemRegistry itemRegistry, PrefixSearchFocusSet prefixSearchFocusSet, FocusSet focusSet) {
        this.searchAttr = stringArray;
        this.searcher = prefixSearchFocusSet;
        this.focus = focusSet;
        this.init(itemRegistry);
    }

    private void init(ItemRegistry itemRegistry) {
        this.registry = itemRegistry;
        itemRegistry.addItemRegistryListener(new ItemRegistryListener(){

            public void registryItemAdded(VisualItem visualItem) {
                if (!visualItem.getItemClass().equals("node")) {
                    return;
                }
                for (int i = 0; i < PrefixSearchPanel.this.searchAttr.length; ++i) {
                    PrefixSearchPanel.this.searcher.index(visualItem.getEntity(), PrefixSearchPanel.this.searchAttr[i]);
                }
                PrefixSearchPanel.this.searchUpdate();
            }

            public void registryItemRemoved(VisualItem visualItem) {
                if (!visualItem.getItemClass().equals("node")) {
                    return;
                }
                for (int i = 0; i < PrefixSearchPanel.this.searchAttr.length; ++i) {
                    PrefixSearchPanel.this.searcher.remove(visualItem.getEntity(), PrefixSearchPanel.this.searchAttr[i]);
                }
                PrefixSearchPanel.this.searchUpdate();
            }
        });
        this.queryF.getDocument().addDocumentListener(this);
        this.queryF.setMaximumSize(new Dimension(100, 20));
        this.upArrow.addActionListener(this);
        this.upArrow.setEnabled(false);
        this.downArrow.addActionListener(this);
        this.downArrow.setEnabled(false);
        this.matchL.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (PrefixSearchPanel.this.matchL.getText().length() > 0) {
                    PrefixSearchPanel.this.matchL.setCursor(new Cursor(12));
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (PrefixSearchPanel.this.matchL.getText().length() > 0) {
                    PrefixSearchPanel.this.matchL.setCursor(new Cursor(0));
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (PrefixSearchPanel.this.matchL.getText().length() > 0) {
                    PrefixSearchPanel.this.focus.set(PrefixSearchPanel.this.m_results[PrefixSearchPanel.this.m_curResult]);
                }
            }
        });
        this.setBackground(Color.WHITE);
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BoxLayout(this, 0));
        Box box = new Box(0);
        box.add(this.resultL);
        box.add(Box.createHorizontalStrut(5));
        box.add(Box.createHorizontalGlue());
        box.add(this.matchL);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.downArrow);
        box.add(this.upArrow);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.searchL);
        box.add(this.queryF);
        this.add(box);
    }

    private void searchUpdate() {
        String string = this.queryF.getText();
        if (string.length() == 0) {
            this.searcher.clear();
            this.resultL.setText("");
            this.matchL.setText("");
            this.downArrow.setEnabled(false);
            this.upArrow.setEnabled(false);
            this.m_results = null;
        } else {
            this.searcher.search(string);
            int n = this.searcher.size();
            this.resultL.setText(n + " match" + (n == 1 ? "" : "es"));
            this.m_results = new Entity[n];
            Iterator iterator = this.searcher.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                this.m_results[n2] = (Entity)iterator.next();
                ++n2;
            }
            if (n > 0) {
                String string2 = "name";
                this.matchL.setText("1/" + n + ": " + this.m_results[0].getAttribute(string2));
                this.downArrow.setEnabled(true);
                this.upArrow.setEnabled(true);
            } else {
                this.matchL.setText("");
                this.downArrow.setEnabled(false);
                this.upArrow.setEnabled(false);
            }
            this.m_curResult = 0;
        }
        this.validate();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.queryF != null) {
            this.queryF.setBackground(color);
        }
        if (this.resultL != null) {
            this.resultL.setBackground(color);
        }
        if (this.matchL != null) {
            this.matchL.setBackground(color);
        }
        if (this.searchL != null) {
            this.searchL.setBackground(color);
        }
        if (this.upArrow != null) {
            this.upArrow.setBackground(color);
        }
        if (this.downArrow != null) {
            this.downArrow.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.queryF != null) {
            this.queryF.setForeground(color);
            this.queryF.setCaretColor(color);
        }
        if (this.resultL != null) {
            this.resultL.setForeground(color);
        }
        if (this.matchL != null) {
            this.matchL.setForeground(color);
        }
        if (this.searchL != null) {
            this.searchL.setForeground(color);
        }
        if (this.upArrow != null) {
            this.upArrow.setForeground(color);
        }
        if (this.downArrow != null) {
            this.downArrow.setForeground(color);
        }
    }

    public void setSearchPrompt(String string) {
        this.searchL.setText(string);
        this.searchL.validate();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.searchUpdate();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.searchUpdate();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.searchUpdate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.matchL.getText().length() == 0) {
            return;
        }
        if (actionEvent.getSource() == this.downArrow) {
            this.m_curResult = (this.m_curResult + 1) % this.m_results.length;
        } else if (actionEvent.getSource() == this.upArrow) {
            this.m_curResult = (this.m_curResult - 1) % this.m_results.length;
            if (this.m_curResult < 0) {
                this.m_curResult += this.m_results.length;
            }
        }
        String string = "name";
        this.matchL.setText(this.m_curResult + 1 + "/" + this.m_results.length + ": " + this.m_results[this.m_curResult].getAttribute(string));
        this.validate();
        this.repaint();
    }

    public class ArrowIcon
    implements Icon {
        public static final int UP = 0;
        public static final int UP_DEPRESSED = 1;
        public static final int DOWN = 2;
        public static final int DOWN_DEPRESSED = 3;
        public static final int DISABLED = 4;
        private int type;

        public ArrowIcon(int n) {
            this.type = n;
        }

        public int getIconHeight() {
            return 11;
        }

        public int getIconWidth() {
            return 11;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.type >= 4) {
                return;
            }
            Polygon polygon = new Polygon();
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            if (this.type < 2) {
                polygon.addPoint(n, n2 + n4 - 1);
                polygon.addPoint(n + n3 - 1, n2 + n4 - 1);
                polygon.addPoint(n + (n3 - 1) / 2, n2);
                polygon.addPoint(n, n2 + n4);
            } else {
                polygon.addPoint(n, n2);
                polygon.addPoint(n + n3 - 1, n2);
                polygon.addPoint(n + (n3 - 1) / 2, n2 + n4 - 1);
                polygon.addPoint(n, n2);
            }
            graphics.setColor(this.type % 2 != 0 ? Color.LIGHT_GRAY : PrefixSearchPanel.this.getForeground());
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.BLACK);
            graphics.drawPolygon(polygon);
        }
    }

    public class IconButton
    extends JButton {
        public IconButton(Icon icon, Icon icon2) {
            super(icon);
            if (icon.getIconWidth() != icon2.getIconWidth() || icon2.getIconHeight() != icon2.getIconHeight()) {
                throw new IllegalArgumentException("Icons must have matching dimensions");
            }
            this.setPressedIcon(icon2);
            this.setDisabledIcon(new ArrowIcon(4));
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.setBackground(this.getBackground());
            Insets insets = this.getMargin();
            insets.left = 0;
            insets.right = 0;
            this.setMargin(insets);
        }
    }
}

