/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.util.display;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.graph.Node;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class DisplayLib {
    private DisplayLib() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle2D getNodeBounds(ItemRegistry itemRegistry, double d, Rectangle2D rectangle2D) {
        rectangle2D.setFrame(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        ItemRegistry itemRegistry2 = itemRegistry;
        synchronized (itemRegistry2) {
            Rectangle2D rectangle2D2;
            NodeItem nodeItem;
            Iterator iterator = itemRegistry.getNodeItems();
            if (iterator.hasNext()) {
                nodeItem = (NodeItem)iterator.next();
                rectangle2D2 = nodeItem.getBounds();
                rectangle2D.setFrame(rectangle2D2);
            }
            while (iterator.hasNext()) {
                nodeItem = (NodeItem)iterator.next();
                rectangle2D2 = nodeItem.getBounds();
                double d2 = rectangle2D2.getMinX() < rectangle2D.getMinX() ? rectangle2D2.getMinX() : rectangle2D.getMinX();
                double d3 = rectangle2D2.getMaxX() > rectangle2D.getMaxX() ? rectangle2D2.getMaxX() : rectangle2D.getMaxX();
                double d4 = rectangle2D2.getMinY() < rectangle2D.getMinY() ? rectangle2D2.getMinY() : rectangle2D.getMinY();
                double d5 = rectangle2D2.getMaxY() > rectangle2D.getMaxY() ? rectangle2D2.getMaxY() : rectangle2D.getMaxY();
                rectangle2D.setFrame(d2, d4, d3 - d2, d5 - d4);
            }
        }
        rectangle2D.setFrame(rectangle2D.getMinX() - d, rectangle2D.getMinY() - d, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d);
        return rectangle2D;
    }

    public static Rectangle2D getNodeBounds(ItemRegistry itemRegistry, double d) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        return DisplayLib.getNodeBounds(itemRegistry, d, double_);
    }

    public static Point2D getCentroid(ItemRegistry itemRegistry, Iterator iterator, Point2D point2D) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            NodeItem nodeItem = null;
            nodeItem = node instanceof NodeItem ? (NodeItem)node : itemRegistry.getNodeItem(node);
            if (nodeItem == null) continue;
            double d3 = nodeItem.getX();
            double d4 = nodeItem.getY();
            if (Double.isInfinite(d3) || Double.isNaN(d3) || Double.isInfinite(d4) || Double.isNaN(d4)) continue;
            d += d3;
            d2 += d4;
            ++n;
        }
        if (n > 0) {
            d /= (double)n;
            d2 /= (double)n;
        }
        point2D.setLocation(d, d2);
        return point2D;
    }

    public static Point2D getCentroid(ItemRegistry itemRegistry, Iterator iterator) {
        return DisplayLib.getCentroid(itemRegistry, iterator, new Point2D.Double());
    }

    public static void fitViewToBounds(Display display, Rectangle2D rectangle2D) {
        DisplayLib.fitViewToBounds(display, rectangle2D, null);
    }

    public static void fitViewToBounds(Display display, Rectangle2D rectangle2D, Point2D point2D) {
        double d = display.getWidth();
        double d2 = display.getHeight();
        double d3 = point2D == null ? rectangle2D.getCenterX() : point2D.getX();
        double d4 = point2D == null ? rectangle2D.getCenterY() : point2D.getY();
        double d5 = Math.max(d3 - rectangle2D.getMinX(), rectangle2D.getMaxX() - d3);
        double d6 = Math.max(d4 - rectangle2D.getMinY(), rectangle2D.getMaxY() - d4);
        double d7 = Math.min(d / (2.0 * d5), d2 / (2.0 * d6)) / display.getScale();
        if (point2D == null) {
            point2D = new Point2D.Double(d3, d4);
        }
        display.animatePanAndZoomToAbs(point2D, d7, 2000L);
    }
}

