/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.distortion;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.assignment.Layout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public abstract class Distortion
extends Layout {
    private Point2D m_tmp = new Point2D.Double();
    private boolean m_sizeDistorted = true;
    private final boolean useFilteredGraph;

    public Distortion(boolean bl) {
        this.useFilteredGraph = bl;
    }

    public void setSizeDistorted(boolean bl) {
        this.m_sizeDistorted = bl;
    }

    public boolean isSizeDistorted() {
        return this.m_sizeDistorted;
    }

    public void run(ItemRegistry itemRegistry, double d) {
        Rectangle2D rectangle2D = this.getLayoutBounds(itemRegistry);
        Point2D point2D = this.correct(this.getLayoutAnchor(), rectangle2D);
        Iterator iterator = this.useFilteredGraph ? itemRegistry.getFilteredGraph().getNodes() : itemRegistry.getNodeItems();
        boolean bl = false;
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            if (visualItem.isFixed()) continue;
            visualItem.getLocation().setLocation(visualItem.getEndLocation());
            visualItem.setSize(visualItem.getEndSize());
            if (point2D == null) continue;
            Rectangle2D rectangle2D2 = visualItem.getBounds();
            Point2D point2D2 = visualItem.getLocation();
            this.transformPoint(visualItem.getEndLocation(), point2D2, point2D, rectangle2D);
            if (!this.m_sizeDistorted) continue;
            double d2 = this.transformSize(rectangle2D2, point2D2, point2D, rectangle2D);
            visualItem.setSize(d2 * visualItem.getEndSize());
        }
    }

    protected Point2D correct(Point2D point2D, Rectangle2D rectangle2D) {
        if (point2D == null) {
            return point2D;
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = rectangle2D.getMinX();
        double d4 = rectangle2D.getMinY();
        double d5 = rectangle2D.getMaxX();
        double d6 = rectangle2D.getMaxY();
        double d7 = d < d3 ? d3 : (d = d > d5 ? d5 : d);
        d2 = d2 < d4 ? d4 : (d2 > d6 ? d6 : d2);
        this.m_tmp.setLocation(d, d2);
        return this.m_tmp;
    }

    protected abstract void transformPoint(Point2D var1, Point2D var2, Point2D var3, Rectangle2D var4);

    protected abstract double transformSize(Rectangle2D var1, Point2D var2, Point2D var3, Rectangle2D var4);
}

