/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.distortion;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefusex.distortion.Distortion;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class FisheyeDistortion
extends Distortion {
    private double dx;
    private double dy;
    private boolean bx;
    private boolean by;
    private double sz = 3.0;

    public FisheyeDistortion() {
        this(4.0);
    }

    public FisheyeDistortion(double d) {
        this(d, d);
    }

    public FisheyeDistortion(double d, double d2) {
        this(d, d2, false);
    }

    public FisheyeDistortion(double d, double d2, boolean bl) {
        super(bl);
        this.dx = d;
        this.dy = d2;
        this.bx = this.dx > 0.0;
        this.by = this.dy > 0.0;
    }

    public double getXDistortionFactor() {
        return this.dx;
    }

    public void setXDistortionFactor(double d) {
        this.dx = d;
    }

    public double getYDistortionFactor() {
        return this.dy;
    }

    public void setYDistortionFactor(double d) {
        this.dy = d;
    }

    protected void transformPoint(Point2D point2D, Point2D point2D2, Point2D point2D3, Rectangle2D rectangle2D) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        if (this.bx) {
            d = this.fisheye(d, point2D3.getX(), this.dx, rectangle2D.getMinX(), rectangle2D.getMaxX());
        }
        if (this.by) {
            d2 = this.fisheye(d2, point2D3.getY(), this.dy, rectangle2D.getMinY(), rectangle2D.getMaxY());
        }
        point2D2.setLocation(d, d2);
    }

    protected double transformSize(Rectangle2D rectangle2D, Point2D point2D, Point2D point2D2, Rectangle2D rectangle2D2) {
        double d;
        double d2;
        double d3;
        double d4;
        if (!this.bx && !this.by) {
            return 1.0;
        }
        double d5 = 1.0;
        double d6 = 1.0;
        if (this.bx) {
            d4 = point2D2.getX();
            d3 = rectangle2D.getX();
            d2 = rectangle2D.getMaxX();
            double d7 = d = Math.abs(d3 - d4) > Math.abs(d2 - d4) ? d3 : d2;
            if (d < rectangle2D2.getMinX() || d > rectangle2D2.getMaxX()) {
                d = d == d3 ? d2 : d3;
            }
            d5 = this.fisheye(d, d4, this.dx, rectangle2D2.getMinX(), rectangle2D2.getMaxX());
            d5 = Math.abs(point2D.getX() - d5) / rectangle2D.getWidth();
        }
        if (this.by) {
            d4 = point2D2.getY();
            d3 = rectangle2D.getY();
            d2 = rectangle2D.getMaxY();
            double d8 = d = Math.abs(d3 - d4) > Math.abs(d2 - d4) ? d3 : d2;
            if (d < rectangle2D2.getMinY() || d > rectangle2D2.getMaxY()) {
                d = d == d3 ? d2 : d3;
            }
            d6 = this.fisheye(d, d4, this.dy, rectangle2D2.getMinY(), rectangle2D2.getMaxY());
            d6 = Math.abs(point2D.getY() - d6) / rectangle2D.getHeight();
        }
        double d9 = !this.by ? d5 : (d4 = !this.bx ? d6 : Math.min(d5, d6));
        if (Double.isInfinite(d4) || Double.isNaN(d4)) {
            return 1.0;
        }
        return this.sz * d4;
    }

    private double fisheye(double d, double d2, double d3, double d4, double d5) {
        if (d3 != 0.0) {
            double d6;
            boolean bl = d < d2;
            double d7 = d6 = bl ? d2 - d4 : d5 - d2;
            if (d6 == 0.0) {
                d6 = d5 - d4;
            }
            double d8 = Math.abs(d - d2) / d6;
            d8 = (d3 + 1.0) / (d3 + 1.0 / d8);
            return (double)(bl ? -1 : 1) * d6 * d8 + d2;
        }
        return d;
    }

    public double fisheyeMove(double d, ItemRegistry itemRegistry) {
        Rectangle2D rectangle2D = this.getLayoutBounds(itemRegistry);
        Point2D point2D = this.correct(this.getLayoutAnchor(), rectangle2D);
        if (point2D != null) {
            return this.fisheye(d, point2D.getX(), this.dx, rectangle2D.getMinX(), rectangle2D.getMaxX());
        }
        return d;
    }
}

