/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.force;

import edu.berkeley.guir.prefusex.force.Force;
import edu.berkeley.guir.prefusex.force.ForceSimulator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ForcePanel
extends JPanel {
    private ForceConstantAction action = new ForceConstantAction();
    private ForceSimulator fsim;

    public ForcePanel(ForceSimulator forceSimulator) {
        this.fsim = forceSimulator;
        this.setBackground(Color.WHITE);
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BoxLayout(this, 1));
        Force[] forceArray = this.fsim.getForces();
        for (int i = 0; i < forceArray.length; ++i) {
            Force force = forceArray[i];
            Box box = new Box(1);
            for (int j = 0; j < force.getParameterCount(); ++j) {
                box.add(this.createField(force, j));
            }
            String string = force.getClass().getName();
            string = string.substring(string.lastIndexOf(".") + 1);
            box.setBorder(BorderFactory.createTitledBorder(string));
            this.add(box);
        }
        this.add(Box.createVerticalGlue());
    }

    private Box createField(Force force, int n) {
        Box box = new Box(0);
        float f = force.getParameter(n);
        JLabel jLabel = new JLabel(force.getParameterName(n));
        jLabel.setPreferredSize(new Dimension(100, 20));
        jLabel.setMaximumSize(new Dimension(100, 20));
        JTextField jTextField = new JTextField(String.valueOf(f));
        jTextField.setPreferredSize(new Dimension(200, 20));
        jTextField.setMaximumSize(new Dimension(200, 20));
        jTextField.putClientProperty("force", force);
        jTextField.putClientProperty("param", new Integer(n));
        jTextField.addActionListener(this.action);
        box.add(jLabel);
        box.add(Box.createHorizontalStrut(10));
        box.add(Box.createHorizontalGlue());
        box.add(jTextField);
        box.setPreferredSize(new Dimension(300, 30));
        box.setMaximumSize(new Dimension(300, 30));
        return box;
    }

    private class ForceConstantAction
    extends AbstractAction {
        private ForceConstantAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            float f = Float.parseFloat(jTextField.getText());
            Force force = (Force)jTextField.getClientProperty("force");
            Integer n = (Integer)jTextField.getClientProperty("param");
            force.setParameter(n, f);
        }
    }
}

