/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.force;

import edu.berkeley.guir.prefusex.force.AbstractForce;
import edu.berkeley.guir.prefusex.force.ForceItem;
import java.awt.geom.Line2D;

public class WallForce
extends AbstractForce {
    private static String[] pnames = new String[]{"GravitationalConstant"};
    public static final float DEFAULT_GRAV_CONSTANT = -0.1f;
    public static final int GRAVITATIONAL_CONST = 0;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private float dx;
    private float dy;

    public WallForce(float f, float f2, float f3, float f4, float f5) {
        this.params = new float[]{f};
        this.x1 = f2;
        this.y1 = f3;
        this.x2 = f4;
        this.y2 = f5;
        this.dx = f4 - f2;
        this.dy = f5 - f3;
        float f6 = (float)Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        if ((double)this.dx != 0.0) {
            this.dx /= f6;
        }
        if ((double)this.dy != 0.0) {
            this.dy /= f6;
        }
    }

    public WallForce(float f, float f2, float f3, float f4) {
        this(-0.1f, f, f2, f3, f4);
    }

    public boolean isItemForce() {
        return true;
    }

    protected String[] getParameterNames() {
        return pnames;
    }

    public void getForce(ForceItem forceItem) {
        float[] fArray = forceItem.location;
        int n = Line2D.relativeCCW(this.x1, this.y1, this.x2, this.y2, fArray[0], fArray[1]);
        float f = (float)Line2D.ptSegDist(this.x1, this.y1, this.x2, this.y2, fArray[0], fArray[1]);
        if ((double)f == 0.0) {
            f = (float)Math.random() / 100.0f;
        }
        float f2 = this.params[0] * forceItem.mass / (f * f * f);
        if (fArray[0] >= Math.min(this.x1, this.x2) && fArray[0] <= Math.max(this.x1, this.x2)) {
            forceItem.force[1] = forceItem.force[1] + (float)n * f2 * this.dx;
        }
        if (fArray[1] >= Math.min(this.y1, this.y2) && fArray[1] <= Math.max(this.y1, this.y2)) {
            forceItem.force[0] = forceItem.force[0] + (float)(-1 * n) * f2 * this.dy;
        }
    }
}

