/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.layout;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.action.assignment.TreeLayout;
import java.awt.geom.Point2D;
import java.util.Iterator;

public class BalloonTreeLayout
extends TreeLayout {
    private ItemRegistry m_registry;
    private int m_minRadius = 2;

    public BalloonTreeLayout() {
        this(2);
    }

    public BalloonTreeLayout(int n) {
    }

    public void run(ItemRegistry itemRegistry, double d) {
        this.m_registry = itemRegistry;
        Point2D point2D = this.getLayoutAnchor(itemRegistry);
        NodeItem nodeItem = this.getLayoutRoot(itemRegistry);
        this.layout(nodeItem, point2D.getX(), point2D.getY());
    }

    public int getMinRadius() {
        return this.m_minRadius;
    }

    public void setMinRadius(int n) {
        this.m_minRadius = n;
    }

    public void layout(NodeItem nodeItem, double d, double d2) {
        this.firstWalk(nodeItem);
        this.secondWalk(nodeItem, null, d, d2, 1.0, 0.0);
    }

    private void firstWalk(NodeItem nodeItem) {
        ParamBlock paramBlock = this.getParams(nodeItem);
        paramBlock.d = 0;
        double d = 0.0;
        Iterator iterator = nodeItem.getChildren();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            this.firstWalk(nodeItem2);
            ParamBlock paramBlock2 = this.getParams(nodeItem2);
            paramBlock.d = Math.max(paramBlock.d, paramBlock2.r);
            paramBlock2.a = Math.atan((double)paramBlock2.r / (double)(paramBlock.d + paramBlock2.r));
            d += paramBlock2.a;
        }
        this.adjustChildren(paramBlock, d);
        this.setRadius(paramBlock);
    }

    private void adjustChildren(ParamBlock paramBlock, double d) {
        if (d > Math.PI) {
            paramBlock.c = Math.PI / d;
            paramBlock.f = 0.0;
        } else {
            paramBlock.c = 1.0;
            paramBlock.f = Math.PI - d;
        }
    }

    private void setRadius(ParamBlock paramBlock) {
        paramBlock.r = Math.max(paramBlock.d, this.m_minRadius) + 2 * paramBlock.d;
    }

    private void setRadius(NodeItem nodeItem, ParamBlock paramBlock) {
        ParamBlock paramBlock2;
        NodeItem nodeItem2;
        int n = nodeItem.getChildCount();
        double d = Math.PI;
        double d2 = n == 0 ? 0.0 : paramBlock.f / (double)n;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        Iterator iterator = nodeItem.getChildren();
        while (iterator.hasNext()) {
            nodeItem2 = (NodeItem)iterator.next();
            paramBlock2 = this.getParams(nodeItem2);
            d4 += (double)paramBlock2.r * Math.cos(d += d3 + paramBlock2.a + d2);
            d5 += (double)paramBlock2.r * Math.sin(d);
            d3 = paramBlock2.a;
        }
        if (n != 0) {
            d4 /= (double)n;
            d5 /= (double)n;
        }
        paramBlock.rx = -d4;
        paramBlock.ry = -d5;
        d = Math.PI;
        d3 = 0.0;
        paramBlock.r = 0;
        iterator = nodeItem.getChildren();
        while (iterator.hasNext()) {
            nodeItem2 = (NodeItem)iterator.next();
            paramBlock2 = this.getParams(nodeItem2);
            double d6 = (double)paramBlock2.r * Math.cos(d += d3 + paramBlock2.a + d2) - d4;
            double d7 = (double)paramBlock2.r * Math.sin(d) - d5;
            double d8 = Math.sqrt(d6 * d6 + d7 * d7) + (double)paramBlock2.r;
            paramBlock.r = Math.max(paramBlock.r, (int)Math.round(d8));
            d3 = paramBlock2.a;
        }
        if (paramBlock.r == 0) {
            paramBlock.r = this.m_minRadius + 2 * paramBlock.d;
        }
    }

    private void secondWalk2(NodeItem nodeItem, NodeItem nodeItem2, double d, double d2, double d3, double d4) {
        ParamBlock paramBlock = this.getParams(nodeItem);
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        double d7 = d + d3 * (paramBlock.rx * d5 - paramBlock.ry * d6);
        double d8 = d2 + d3 * (paramBlock.rx * d6 + paramBlock.ry * d5);
        this.setLocation(nodeItem, nodeItem2, d7, d8);
        double d9 = d3 * (double)paramBlock.d;
        double d10 = Math.PI;
        double d11 = paramBlock.f / (double)(nodeItem.getChildCount() + 1);
        double d12 = 0.0;
        Iterator iterator = nodeItem.getChildren();
        while (iterator.hasNext()) {
            NodeItem nodeItem3 = (NodeItem)iterator.next();
            ParamBlock paramBlock2 = this.getParams(nodeItem3);
            double d13 = paramBlock.c * paramBlock2.a;
            double d14 = (double)paramBlock.d * Math.tan(d13) / (1.0 - Math.tan(d13));
            double d15 = (d3 * d14 + d9) * Math.cos(d10 += d12 + d13 + d11) + paramBlock.rx;
            double d16 = (d3 * d14 + d9) * Math.sin(d10) + paramBlock.ry;
            double d17 = d15 * d5 - d16 * d6;
            double d18 = d15 * d6 + d16 * d5;
            d12 = d13;
            this.secondWalk2(nodeItem3, nodeItem, d + d17, d2 + d18, d3 * d14 / (double)paramBlock2.r, d10);
        }
    }

    private void secondWalk(NodeItem nodeItem, NodeItem nodeItem2, double d, double d2, double d3, double d4) {
        this.setLocation(nodeItem, nodeItem2, d, d2);
        ParamBlock paramBlock = this.getParams(nodeItem);
        int n = nodeItem.getChildCount();
        double d5 = d3 * (double)paramBlock.d;
        double d6 = d4 + Math.PI;
        double d7 = n == 0 ? 0.0 : paramBlock.f / (double)n;
        double d8 = 0.0;
        Iterator iterator = nodeItem.getChildren();
        while (iterator.hasNext()) {
            NodeItem nodeItem3 = (NodeItem)iterator.next();
            ParamBlock paramBlock2 = this.getParams(nodeItem3);
            double d9 = paramBlock.c * paramBlock2.a;
            double d10 = (double)paramBlock.d * Math.tan(d9) / (1.0 - Math.tan(d9));
            double d11 = (d3 * d10 + d5) * Math.cos(d6 += d8 + d9 + d7);
            double d12 = (d3 * d10 + d5) * Math.sin(d6);
            d8 = d9;
            this.secondWalk(nodeItem3, nodeItem, d + d11, d2 + d12, d3 * paramBlock.c, d6);
        }
    }

    private ParamBlock getParams(NodeItem nodeItem) {
        ParamBlock paramBlock = (ParamBlock)nodeItem.getVizAttribute("balloonParams");
        if (paramBlock == null) {
            paramBlock = new ParamBlock();
            nodeItem.setVizAttribute("balloonParams", paramBlock);
        }
        return paramBlock;
    }

    public class ParamBlock {
        public int d;
        public int r;
        public double rx;
        public double ry;
        public double a;
        public double c;
        public double f;
    }
}

