/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.layout;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.action.assignment.Layout;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class GridLayout
extends Layout {
    protected int rows;
    protected int cols;
    protected boolean sorted = false;
    protected boolean analyze = false;

    public GridLayout() {
        this.analyze = true;
    }

    public GridLayout(int n, int n2) {
        this(n, n2, false);
    }

    public GridLayout(int n, int n2, boolean bl) {
        this.rows = n;
        this.cols = n2;
        bl = true;
        this.analyze = false;
    }

    public void run(ItemRegistry itemRegistry, double d) {
        Object object;
        Rectangle2D rectangle2D = this.getLayoutBounds(itemRegistry);
        double d2 = rectangle2D.getMinX();
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        Graph graph = itemRegistry.getFilteredGraph();
        int n = this.rows;
        int n2 = this.cols;
        if (this.analyze) {
            object = GridLayout.analyzeGraphGrid(graph);
            n = object[0];
            n2 = object[1];
        }
        object = this.sorted ? itemRegistry.getNodeItems() : graph.getNodes();
        for (int i = 0; object.hasNext() && i < n * n2; ++i) {
            NodeItem nodeItem = (NodeItem)object.next();
            nodeItem.setVisible(true);
            this.setEdgeVisibility(nodeItem, true);
            double d6 = d2 + d4 * ((double)(i % n2) / (double)(n2 - 1));
            double d7 = d3 + d5 * ((double)(i / n2) / (double)(n - 1));
            this.setLocation(nodeItem, null, d6, d7);
        }
        while (object.hasNext()) {
            NodeItem nodeItem = (NodeItem)object.next();
            nodeItem.setVisible(false);
            this.setEdgeVisibility(nodeItem, false);
        }
    }

    private void setEdgeVisibility(NodeItem nodeItem, boolean bl) {
        Iterator iterator = nodeItem.getEdges();
        while (iterator.hasNext()) {
            EdgeItem edgeItem = (EdgeItem)iterator.next();
            edgeItem.setVisible(bl);
        }
    }

    public static int[] analyzeGraphGrid(Graph graph) {
        Node node;
        Iterator iterator = graph.getNodes();
        iterator.next();
        int n = 2;
        while (iterator.hasNext() && (node = (Node)iterator.next()).getEdgeCount() != 2) {
            ++n;
        }
        int n2 = graph.getNodeCount() / n;
        return new int[]{n2, n};
    }

    public int getNumCols() {
        return this.cols;
    }

    public void setNumCols(int n) {
        this.cols = n;
    }

    public int getNumRows() {
        return this.rows;
    }

    public void setNumRows(int n) {
        this.rows = n;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean bl) {
        this.sorted = bl;
    }
}

