/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.layout;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.assignment.TreeLayout;
import edu.berkeley.guir.prefuse.event.FocusEvent;
import edu.berkeley.guir.prefuse.event.FocusListener;
import edu.berkeley.guir.prefuse.graph.Entity;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class RadialTreeLayout
extends TreeLayout
implements FocusListener {
    public static final int DEFAULT_RADIUS = 50;
    protected static final double TWO_PI = Math.PI * 2;
    protected int m_maxDepth = 0;
    protected double m_radiusInc;
    protected double m_startTheta;
    protected double m_endTheta;
    protected boolean m_setTheta = false;
    protected boolean m_autoScale = true;
    protected Point2D m_origin;
    protected TreeNode m_prevParent;
    protected NodeItem m_pfocus;
    protected NodeItem m_focus;
    protected ItemRegistry m_registry;

    public RadialTreeLayout() {
        this(50);
    }

    public RadialTreeLayout(int n) {
        this.m_radiusInc = n;
        this.m_prevParent = null;
        this.m_startTheta = 0.0;
        this.m_endTheta = Math.PI * 2;
    }

    public double getRadiusIncrement() {
        return this.m_radiusInc;
    }

    public void setRadiusIncrement(double d) {
        this.m_radiusInc = d;
    }

    public boolean getAutoScale() {
        return this.m_autoScale;
    }

    public void setAutoScale(boolean bl) {
        this.m_autoScale = bl;
    }

    public void setStartTheta(double d) {
        this.m_startTheta = d;
        this.m_setTheta = true;
    }

    public void setEndTheta(double d) {
        this.m_endTheta = d;
        this.m_setTheta = true;
    }

    public void run(ItemRegistry itemRegistry, double d) {
        if (this.m_registry != itemRegistry) {
            if (this.m_registry != null) {
                this.m_registry.getDefaultFocusSet().removeFocusListener(this);
            }
            this.m_registry = itemRegistry;
            this.m_registry.getDefaultFocusSet().addFocusListener(this);
        }
        this.m_origin = this.getLayoutAnchor(itemRegistry);
        NodeItem nodeItem = this.getLayoutRoot(itemRegistry);
        RadialParams radialParams = this.getParams(nodeItem);
        this.m_maxDepth = 0;
        this.countVisibleDescendants(nodeItem, 0);
        if (this.m_autoScale) {
            this.setScale(this.getLayoutBounds(itemRegistry));
        }
        if (!this.m_setTheta && this.m_pfocus != null) {
            NodeItem nodeItem2 = this.getPrevParent(this.m_focus, this.m_pfocus);
            this.m_startTheta = this.calcStartingTheta(nodeItem, nodeItem2);
            this.m_endTheta = this.m_startTheta + Math.PI * 2;
        }
        this.setLocation(nodeItem, null, this.m_origin.getX(), this.m_origin.getY());
        radialParams.angle = this.m_endTheta - this.m_startTheta;
        this.layout(nodeItem, this.m_radiusInc, this.m_startTheta, this.m_endTheta);
        this.m_prevParent = null;
    }

    protected void setScale(Rectangle2D rectangle2D) {
        double d = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()) / 2.0;
        if (this.m_maxDepth > 0) {
            this.m_radiusInc = (d - 40.0) / (double)this.m_maxDepth;
        }
    }

    private NodeItem getPrevParent(NodeItem nodeItem, NodeItem nodeItem2) {
        while (nodeItem2 != null && nodeItem2.getParent() != nodeItem) {
            nodeItem2 = (NodeItem)nodeItem2.getParent();
        }
        return nodeItem2;
    }

    private double calcStartingTheta(NodeItem nodeItem, NodeItem nodeItem2) {
        if (nodeItem2 == null) {
            return 0.0;
        }
        Point2D point2D = nodeItem2.getLocation();
        Point2D point2D2 = nodeItem.getLocation();
        double d = Math.atan2(point2D.getY() - point2D2.getY(), point2D.getX() - point2D2.getX());
        int n = nodeItem.getChildIndex(nodeItem2);
        int n2 = this.getParams((VisualItem)nodeItem).numDescendants;
        int n3 = this.getParams((VisualItem)nodeItem2).numDescendants;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            n4 += this.getParams((VisualItem)((NodeItem)nodeItem.getChild((int)i))).numDescendants;
        }
        double d2 = ((double)n4 + (double)n3 / 2.0) / (double)n2;
        return d - d2 * (Math.PI * 2);
    }

    private int countVisibleDescendants(NodeItem nodeItem, int n) {
        if (n > this.m_maxDepth) {
            this.m_maxDepth = n;
        }
        int n2 = 0;
        if (nodeItem.getChildCount() > 0) {
            Iterator iterator = nodeItem.getChildren();
            while (iterator.hasNext()) {
                NodeItem nodeItem2 = (NodeItem)iterator.next();
                n2 += this.countVisibleDescendants(nodeItem2, n + 1);
            }
        } else {
            n2 = 1;
        }
        this.getParams((VisualItem)nodeItem).numDescendants = n2;
        return n2;
    }

    protected void layout(NodeItem nodeItem, double d, double d2, double d3) {
        int n = this.getParams((VisualItem)nodeItem).numDescendants;
        if (n == 0) {
            return;
        }
        double d4 = d3 - d2;
        double d5 = d4 / 2.0;
        double d6 = 0.0;
        Iterator iterator = nodeItem.getChildren();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            RadialParams radialParams = this.getParams(nodeItem2);
            double d7 = (double)radialParams.numDescendants / (double)n;
            this.setPolarLocation(nodeItem2, d, d2 + d6 * d4 + d7 * d5);
            radialParams.angle = d7 * d4;
            this.layout(nodeItem2, d + this.m_radiusInc, d2 + d6 * d4, d2 + (d6 + d7) * d4);
            d6 += d7;
        }
    }

    protected void setPolarLocation(NodeItem nodeItem, double d, double d2) {
        double d3 = this.m_origin.getX() + d * Math.cos(d2);
        double d4 = this.m_origin.getY() + d * Math.sin(d2);
        super.setLocation(nodeItem, (NodeItem)nodeItem.getParent(), d3, d4);
    }

    public void focusChanged(FocusEvent focusEvent) {
        if (focusEvent.getEventType() != 2) {
            return;
        }
        Entity entity = focusEvent.getFirstAdded();
        Entity entity2 = focusEvent.getFirstRemoved();
        if (entity instanceof Node && entity2 instanceof Node) {
            this.m_focus = this.m_registry.getNodeItem((Node)entity);
            this.m_pfocus = this.m_registry.getNodeItem((Node)entity2);
        } else {
            this.m_pfocus = this.m_focus;
            this.m_focus = null;
        }
    }

    private RadialParams getParams(VisualItem visualItem) {
        RadialParams radialParams = (RadialParams)visualItem.getVizAttribute("radialParams");
        if (radialParams == null) {
            radialParams = new RadialParams();
            visualItem.setVizAttribute("radialParams", radialParams);
        }
        return radialParams;
    }

    public class RadialParams {
        int numDescendants;
        double angle;
    }
}

