/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.layout;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.action.assignment.TreeLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;

public class VerticalTreeLayout
extends TreeLayout {
    protected HashMap m_counts;
    protected int m_heightInc = 25;
    protected ItemRegistry m_registry;

    public VerticalTreeLayout() {
        try {
            this.m_counts = new HashMap();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Point2D getLayoutAnchor(ItemRegistry itemRegistry) {
        Point2D point2D = super.getLayoutAnchor();
        if (point2D != null) {
            return point2D;
        }
        Rectangle2D rectangle2D = this.getLayoutBounds(itemRegistry);
        double d = 0.0;
        double d2 = 0.0;
        if (rectangle2D != null) {
            d = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
            d2 = rectangle2D.getY() + 20.0;
        }
        return new Point2D.Double(d, d2);
    }

    public void run(ItemRegistry itemRegistry, double d) {
        this.m_registry = itemRegistry;
        Rectangle2D rectangle2D = this.getLayoutBounds(itemRegistry);
        Point2D point2D = this.getLayoutAnchor(itemRegistry);
        NodeItem nodeItem = this.getLayoutRoot(itemRegistry);
        if (nodeItem != null && nodeItem.isVisible()) {
            this.countVisibleDescendants(nodeItem);
            this.setLocation(nodeItem, null, point2D.getX(), point2D.getY());
            this.layout(nodeItem, (int)point2D.getY() + this.m_heightInc, rectangle2D.getX(), rectangle2D.getX() + rectangle2D.getWidth());
            this.m_counts.clear();
        } else {
            System.err.println("VerticalTreeLayout: Tree root not visible!");
        }
    }

    private int countVisibleDescendants(NodeItem nodeItem) {
        int n = 0;
        Iterator iterator = nodeItem.getChildren();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            n += this.countVisibleDescendants(nodeItem2);
        }
        if (n == 0) {
            n = 1;
        }
        this.setVisibleDescendants(nodeItem, n);
        return n;
    }

    private void setVisibleDescendants(NodeItem nodeItem, int n) {
        this.m_counts.put(nodeItem, new Integer(n));
    }

    private int getVisibleDescendants(NodeItem nodeItem) {
        Integer n = (Integer)this.m_counts.get(nodeItem);
        return n == null ? 0 : n;
    }

    protected void layout(NodeItem nodeItem, int n, double d, double d2) {
        int n2 = this.getVisibleDescendants(nodeItem);
        boolean bl = false;
        if (n2 == 0) {
            return;
        }
        double d3 = d2 - d;
        double d4 = d3 / 2.0;
        double d5 = 0.0;
        Iterator iterator = nodeItem.getChildren();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            double d6 = (double)this.getVisibleDescendants(nodeItem2) / (double)n2;
            this.setLocation(nodeItem2, nodeItem, d + d5 * d3 + d6 * d4, n);
            this.layout(nodeItem2, n + this.m_heightInc, d + d5 * d3, d + (d5 + d6) * d3);
            d5 += d6;
        }
    }
}

