/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http;

import org.apache.http.ProtocolException;
import org.apache.http.io.CharArrayBuffer;
import org.apache.http.protocol.HTTP;

public class HttpVersion
implements Comparable {
    private int major = 0;
    private int minor = 0;
    public static final HttpVersion HTTP_0_9 = new HttpVersion(0, 9);
    public static final HttpVersion HTTP_1_0 = new HttpVersion(1, 0);
    public static final HttpVersion HTTP_1_1 = new HttpVersion(1, 1);

    public HttpVersion(int major, int minor) {
        if (major < 0) {
            throw new IllegalArgumentException("HTTP major version number may not be negative");
        }
        this.major = major;
        if (minor < 0) {
            throw new IllegalArgumentException("HTTP minor version number may not be negative");
        }
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int hashCode() {
        return this.major * 100000 + this.minor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HttpVersion)) {
            return false;
        }
        return this.equals((HttpVersion)obj);
    }

    public int compareTo(HttpVersion anotherVer) {
        if (anotherVer == null) {
            throw new IllegalArgumentException("Version parameter may not be null");
        }
        int delta = this.getMajor() - anotherVer.getMajor();
        if (delta == 0) {
            delta = this.getMinor() - anotherVer.getMinor();
        }
        return delta;
    }

    public int compareTo(Object o) {
        return this.compareTo((HttpVersion)o);
    }

    public boolean equals(HttpVersion version) {
        return this.compareTo(version) == 0;
    }

    public boolean greaterEquals(HttpVersion version) {
        return this.compareTo(version) >= 0;
    }

    public boolean lessEquals(HttpVersion version) {
        return this.compareTo(version) <= 0;
    }

    public String toString() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append("HTTP/");
        buffer.append(Integer.toString(this.major));
        buffer.append('.');
        buffer.append(Integer.toString(this.minor));
        return buffer.toString();
    }

    public static HttpVersion parse(CharArrayBuffer buffer, int indexFrom, int indexTo) throws ProtocolException {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (indexFrom < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (indexTo > buffer.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (indexFrom > indexTo) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int minor;
            int major;
            int i = indexFrom;
            while (HTTP.isWhitespace(buffer.charAt(i))) {
                ++i;
            }
            if (buffer.charAt(i) != 'H' || buffer.charAt(i + 1) != 'T' || buffer.charAt(i + 2) != 'T' || buffer.charAt(i + 3) != 'P' || buffer.charAt(i + 4) != '/') {
                throw new ProtocolException("Not a valid HTTP version string: " + buffer.substring(indexFrom, indexTo));
            }
            int period = buffer.indexOf(46, i += 5, indexTo);
            if (period == -1) {
                throw new ProtocolException("Invalid HTTP version number: " + buffer.substring(indexFrom, indexTo));
            }
            try {
                major = Integer.parseInt(buffer.substringTrimmed(i, period));
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("Invalid HTTP major version number: " + buffer.substring(indexFrom, indexTo));
            }
            try {
                minor = Integer.parseInt(buffer.substringTrimmed(period + 1, indexTo));
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("Invalid HTTP minor version number: " + buffer.substring(indexFrom, indexTo));
            }
            return new HttpVersion(major, minor);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProtocolException("Invalid HTTP version string: " + buffer.substring(indexFrom, indexTo));
        }
    }

    public static final HttpVersion parse(String s) throws ProtocolException {
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(s);
        return HttpVersion.parse(buffer, 0, buffer.length());
    }

    public static void format(CharArrayBuffer buffer, HttpVersion ver) {
        if (buffer == null) {
            throw new IllegalArgumentException("String buffer may not be null");
        }
        if (ver == null) {
            throw new IllegalArgumentException("Version may not be null");
        }
        buffer.append("HTTP/");
        buffer.append(Integer.toString(ver.getMajor()));
        buffer.append('.');
        buffer.append(Integer.toString(ver.getMinor()));
    }

    public static String format(HttpVersion ver) {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        HttpVersion.format(buffer, ver);
        return buffer.toString();
    }
}

