/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http;

import java.util.ArrayList;
import org.apache.http.io.CharArrayBuffer;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.LangUtils;

public class NameValuePair {
    private final String name;
    private final String value;
    private static final char[] SEPARATORS = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}', ' ', '\t'};
    private static final char[] UNSAFE_CHARS = new char[]{'\"', '\\'};

    public NameValuePair(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static final NameValuePair[] parseAll(CharArrayBuffer buffer, int indexFrom, int indexTo) {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (indexFrom < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (indexTo > buffer.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (indexFrom > indexTo) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        int from = indexFrom;
        boolean qouted = false;
        boolean escaped = false;
        for (int cur = indexFrom; cur < indexTo; ++cur) {
            char ch = buffer.charAt(cur);
            if (ch == '\"' && !escaped) {
                qouted = !qouted;
            }
            NameValuePair param = null;
            if (!qouted && ch == ';') {
                param = NameValuePair.parse(buffer, from, cur);
                from = cur + 1;
            } else if (cur == indexTo - 1) {
                param = NameValuePair.parse(buffer, from, indexTo);
            }
            if (!(param == null || param.getName().equals("") && param.getValue() == null)) {
                params.add(param);
            }
            escaped = escaped ? false : qouted && ch == '\\';
        }
        return params.toArray(new NameValuePair[params.size()]);
    }

    public static final NameValuePair[] parseAll(String s) {
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(s);
        return NameValuePair.parseAll(buffer, 0, buffer.length());
    }

    public static NameValuePair parse(CharArrayBuffer buffer, int indexFrom, int indexTo) {
        int i1;
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (indexFrom < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (indexTo > buffer.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (indexFrom > indexTo) {
            throw new IndexOutOfBoundsException();
        }
        int eq = buffer.indexOf(61, indexFrom, indexTo);
        if (eq < 0) {
            return new NameValuePair(buffer.substringTrimmed(indexFrom, indexTo), null);
        }
        String name = buffer.substringTrimmed(indexFrom, eq);
        int i2 = indexTo;
        for (i1 = eq + 1; i1 < i2 && HTTP.isWhitespace(buffer.charAt(i1)); ++i1) {
        }
        while (i2 > i1 && HTTP.isWhitespace(buffer.charAt(i2 - 1))) {
            --i2;
        }
        if (i2 - i1 >= 2 && buffer.charAt(i1) == '\"' && buffer.charAt(i2 - 1) == '\"') {
            ++i1;
            --i2;
        }
        String value = buffer.substring(i1, i2);
        return new NameValuePair(name, value);
    }

    public static final NameValuePair parse(String s) {
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(s);
        return NameValuePair.parse(buffer, 0, buffer.length());
    }

    private static boolean isOneOf(char[] chars, char ch) {
        for (int i = 0; i < chars.length; ++i) {
            if (ch != chars[i]) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnsafeChar(char ch) {
        return NameValuePair.isOneOf(UNSAFE_CHARS, ch);
    }

    private static boolean isSeparator(char ch) {
        return NameValuePair.isOneOf(SEPARATORS, ch);
    }

    private static void format(CharArrayBuffer buffer, String value, boolean alwaysUseQuotes) {
        int i;
        boolean unsafe = false;
        if (alwaysUseQuotes) {
            unsafe = true;
        } else {
            for (i = 0; i < value.length(); ++i) {
                if (!NameValuePair.isSeparator(value.charAt(i))) continue;
                unsafe = true;
                break;
            }
        }
        if (unsafe) {
            buffer.append('\"');
        }
        for (i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (NameValuePair.isUnsafeChar(ch)) {
                buffer.append('\\');
            }
            buffer.append(ch);
        }
        if (unsafe) {
            buffer.append('\"');
        }
    }

    public static void format(CharArrayBuffer buffer, NameValuePair param, boolean alwaysUseQuotes) {
        if (buffer == null) {
            throw new IllegalArgumentException("String buffer may not be null");
        }
        if (param == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        buffer.append(param.getName());
        String value = param.getValue();
        if (value != null) {
            buffer.append("=");
            NameValuePair.format(buffer, value, alwaysUseQuotes);
        }
    }

    public static void formatAll(CharArrayBuffer buffer, NameValuePair[] params, boolean alwaysUseQuotes) {
        if (buffer == null) {
            throw new IllegalArgumentException("String buffer may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("Array of parameter may not be null");
        }
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                buffer.append("; ");
            }
            NameValuePair.format(buffer, params[i], alwaysUseQuotes);
        }
    }

    public static String format(NameValuePair param, boolean alwaysUseQuotes) {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        NameValuePair.format(buffer, param, alwaysUseQuotes);
        return buffer.toString();
    }

    public static String formatAll(NameValuePair[] params, boolean alwaysUseQuotes) {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        NameValuePair.formatAll(buffer, params, alwaysUseQuotes);
        return buffer.toString();
    }

    public String toString() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append(this.name);
        if (this.value != null) {
            buffer.append("=");
            NameValuePair.format(buffer, this.value, false);
        }
        return buffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof NameValuePair) {
            NameValuePair that = (NameValuePair)object;
            return this.name.equals(that.name) && LangUtils.equals(this.value, that.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.name);
        hash = LangUtils.hashCode(hash, this.value);
        return hash;
    }
}

