/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import java.net.Socket;
import org.apache.http.HttpConnection;
import org.apache.http.impl.io.SocketHttpDataReceiver;
import org.apache.http.impl.io.SocketHttpDataTransmitter;
import org.apache.http.io.HttpDataReceiver;
import org.apache.http.io.HttpDataReceiverFactory;
import org.apache.http.io.HttpDataTransmitter;
import org.apache.http.io.HttpDataTransmitterFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

abstract class AbstractHttpConnection
implements HttpConnection {
    protected volatile boolean open;
    protected Socket socket = null;
    protected HttpDataTransmitter datatransmitter = null;
    protected HttpDataReceiver datareceiver = null;
    private HttpDataTransmitterFactory trxfactory = null;
    private HttpDataReceiverFactory rcvfactory = null;

    protected AbstractHttpConnection() {
    }

    public void setReceiverFactory(HttpDataReceiverFactory rcvfactory) {
        if (rcvfactory == null) {
            throw new IllegalArgumentException("Factory may not be null");
        }
        this.rcvfactory = rcvfactory;
    }

    public void setTransmitterFactory(HttpDataTransmitterFactory trxfactory) {
        if (trxfactory == null) {
            throw new IllegalArgumentException("Factory may not be null");
        }
        this.trxfactory = trxfactory;
    }

    protected void assertNotOpen() {
        if (this.open) {
            throw new IllegalStateException("Connection is already open");
        }
    }

    protected void assertOpen() {
        if (!this.open) {
            throw new IllegalStateException("Connection is not open");
        }
    }

    protected void bind(Socket socket, HttpParams params) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(params));
        int linger = HttpConnectionParams.getLinger(params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
        int buffersize = HttpConnectionParams.getSocketBufferSize(params);
        this.assertNotOpen();
        this.open = true;
        this.socket = socket;
        this.datatransmitter = this.trxfactory != null ? this.trxfactory.create(this.socket) : new SocketHttpDataTransmitter(this.socket, buffersize);
        this.datareceiver = this.rcvfactory != null ? this.rcvfactory.create(this.socket) : new SocketHttpDataReceiver(this.socket, buffersize);
        this.datatransmitter.reset(params);
        this.datareceiver.reset(params);
    }

    public boolean isOpen() {
        return this.open;
    }

    public void shutdown() throws IOException {
        this.open = false;
        Socket tmpsocket = this.socket;
        if (tmpsocket != null) {
            tmpsocket.close();
        }
    }

    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.datatransmitter.flush();
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            this.socket.shutdownInput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket.close();
    }

    public boolean isStale() {
        this.assertOpen();
        try {
            this.datareceiver.isDataAvailable(1);
            return false;
        }
        catch (IOException ex) {
            return true;
        }
    }
}

