/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolException;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.entity.EntityDeserializer;
import org.apache.http.entity.EntitySerializer;
import org.apache.http.impl.AbstractHttpConnection;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.entity.DefaultEntityDeserializer;
import org.apache.http.impl.entity.DefaultEntitySerializer;
import org.apache.http.io.CharArrayBuffer;
import org.apache.http.io.SocketFactory;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.HeaderUtils;

public class DefaultHttpClientConnection
extends AbstractHttpConnection
implements HttpClientConnection {
    private HttpHost targethost = null;
    private InetAddress localAddress = null;
    private int maxHeaderCount = -1;
    private final CharArrayBuffer buffer;
    private HttpResponseFactory responsefactory = null;
    private EntitySerializer entityserializer = null;
    private EntityDeserializer entitydeserializer = null;

    public DefaultHttpClientConnection(HttpHost targethost, InetAddress localAddress) {
        this.targethost = targethost;
        this.localAddress = localAddress;
        this.buffer = new CharArrayBuffer(128);
        this.responsefactory = new DefaultHttpResponseFactory();
        this.entityserializer = new DefaultEntitySerializer();
        this.entitydeserializer = new DefaultEntityDeserializer();
    }

    public DefaultHttpClientConnection(HttpHost targethost) {
        this(targethost, null);
    }

    public DefaultHttpClientConnection() {
        this(null, null);
    }

    public void setResponseFactory(HttpResponseFactory responsefactory) {
        if (responsefactory == null) {
            throw new IllegalArgumentException("Factory may not be null");
        }
        this.responsefactory = responsefactory;
    }

    public void setEntityDeserializer(EntityDeserializer entitydeserializer) {
        if (entitydeserializer == null) {
            throw new IllegalArgumentException("Entity deserializer may not be null");
        }
        this.entitydeserializer = entitydeserializer;
    }

    public void setEntitySerializer(EntitySerializer entityserializer) {
        if (entityserializer == null) {
            throw new IllegalArgumentException("Entity serializer may not be null");
        }
        this.entityserializer = entityserializer;
    }

    public void open(HttpParams params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.assertNotOpen();
        if (this.targethost == null) {
            throw new IllegalStateException("Target host not specified");
        }
        SocketFactory socketfactory = this.targethost.getScheme().getSocketFactory();
        Socket socket = socketfactory.createSocket(this.targethost.getHostName(), this.targethost.getPort(), this.localAddress, 0, params);
        this.bind(socket, params);
        this.maxHeaderCount = params.getIntParameter("http.connection.max-header-count", -1);
    }

    public HttpHost getTargetHost() {
        return this.targethost;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setTargetHost(HttpHost targethost) {
        if (targethost == null) {
            throw new IllegalArgumentException("Target host may not be null");
        }
        this.assertNotOpen();
        this.targethost = targethost;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.assertNotOpen();
        this.localAddress = localAddress;
    }

    public boolean isResponseAvailable(int timeout) throws IOException {
        this.assertOpen();
        return this.datareceiver.isDataAvailable(timeout);
    }

    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        this.sendRequestLine(request);
        this.sendRequestHeaders(request);
    }

    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        if (request.getEntity() == null) {
            return;
        }
        this.entityserializer.serialize(this.datatransmitter, request, request.getEntity());
    }

    public void flush() throws IOException {
        this.datatransmitter.flush();
    }

    protected void sendRequestLine(HttpRequest request) throws HttpException, IOException {
        this.buffer.clear();
        RequestLine.format(this.buffer, request.getRequestLine());
        this.datatransmitter.writeLine(this.buffer);
    }

    protected void sendRequestHeaders(HttpRequest request) throws HttpException, IOException {
        Header[] headers = request.getAllHeaders();
        for (int i = 0; i < headers.length; ++i) {
            this.buffer.clear();
            Header.format(this.buffer, headers[i]);
            this.datatransmitter.writeLine(this.buffer);
        }
        this.buffer.clear();
        this.datatransmitter.writeLine(this.buffer);
    }

    public HttpResponse receiveResponseHeader(HttpParams params) throws HttpException, IOException {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.assertOpen();
        HttpResponse response = this.readResponseStatusLine(params);
        this.readResponseHeaders(response);
        return response;
    }

    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        this.assertOpen();
        HttpEntity entity = this.entitydeserializer.deserialize(this.datareceiver, response);
        response.setEntity(entity);
    }

    private static boolean startsWithHTTP(CharArrayBuffer buffer) {
        try {
            int i = 0;
            while (HTTP.isWhitespace(buffer.charAt(i))) {
                ++i;
            }
            return buffer.charAt(i) == 'H' && buffer.charAt(i + 1) == 'T' && buffer.charAt(i + 2) == 'T' && buffer.charAt(i + 3) == 'P';
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    protected HttpResponse readResponseStatusLine(HttpParams params) throws HttpException, IOException {
        this.buffer.clear();
        int maxGarbageLines = params.getIntParameter("http.protocol.status-line-garbage-limit", Integer.MAX_VALUE);
        int count = 0;
        while (true) {
            int i;
            if ((i = this.datareceiver.readLine(this.buffer)) == -1 && count == 0) {
                throw new NoHttpResponseException("The server " + this.targethost.getHostName() + " failed to respond");
            }
            if (DefaultHttpClientConnection.startsWithHTTP(this.buffer)) break;
            if (i == -1 || count >= maxGarbageLines) {
                throw new ProtocolException("The server " + this.targethost.getHostName() + " failed to respond with a valid HTTP response");
            }
            ++count;
        }
        StatusLine statusline = StatusLine.parse(this.buffer, 0, this.buffer.length());
        HttpResponse response = this.responsefactory.newHttpResponse(statusline);
        response.getParams().setDefaults(params);
        return response;
    }

    protected void readResponseHeaders(HttpResponse response) throws HttpException, IOException {
        Header[] headers = HeaderUtils.parseHeaders(this.datareceiver, this.maxHeaderCount);
        for (int i = 0; i < headers.length; ++i) {
            response.addHeader(headers[i]);
        }
    }
}

