/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.RequestLine;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;

public class DefaultHttpRequestFactory
implements HttpRequestFactory {
    public HttpRequest newHttpRequest(RequestLine requestline) throws MethodNotSupportedException {
        if (requestline == null) {
            throw new IllegalArgumentException("Request line may not be null");
        }
        String method = requestline.getMethod();
        if ("GET".equalsIgnoreCase(method)) {
            return new BasicHttpRequest(requestline);
        }
        if ("HEAD".equalsIgnoreCase(method)) {
            return new BasicHttpRequest(requestline);
        }
        if ("POST".equalsIgnoreCase(method)) {
            return new BasicHttpEntityEnclosingRequest(requestline);
        }
        throw new MethodNotSupportedException(method + " method not supported");
    }

    public HttpRequest newHttpRequest(String method, String uri) throws MethodNotSupportedException {
        if ("GET".equalsIgnoreCase(method)) {
            return new BasicHttpRequest(method, uri);
        }
        if ("POST".equalsIgnoreCase(method)) {
            return new BasicHttpEntityEnclosingRequest(method, uri);
        }
        throw new MethodNotSupportedException(method + " method not supported");
    }
}

