/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.entity;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.ProtocolException;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.EntityDeserializer;
import org.apache.http.io.ChunkedInputStream;
import org.apache.http.io.ContentLengthInputStream;
import org.apache.http.io.HttpDataInputStream;
import org.apache.http.io.HttpDataReceiver;
import org.apache.http.params.HttpParams;

public class DefaultEntityDeserializer
implements EntityDeserializer {
    protected BasicHttpEntity doDeserialize(HttpDataReceiver datareceiver, HttpMessage message) throws HttpException, IOException {
        if (datareceiver == null) {
            throw new IllegalArgumentException("HTTP data receiver may not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("HTTP message may not be null");
        }
        BasicHttpEntity entity = new BasicHttpEntity();
        HttpParams params = message.getParams();
        boolean strict = params.isParameterTrue("http.protocol.strict-transfer-encoding");
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        Header contentEncodingHeader = message.getFirstHeader("Content-Encoding");
        Header transferEncodingHeader = message.getFirstHeader("Transfer-Encoding");
        Header contentLengthHeader = message.getFirstHeader("Content-Length");
        if (transferEncodingHeader != null) {
            HeaderElement[] encodings = transferEncodingHeader.getElements();
            if (strict) {
                for (int i = 0; i < encodings.length; ++i) {
                    String encoding = encodings[i].getName();
                    if (encoding == null || encoding.equals("") || encoding.equalsIgnoreCase("chunked") || encoding.equalsIgnoreCase("identity")) continue;
                    throw new ProtocolException("Unsupported transfer encoding: " + encoding);
                }
            }
            int len = encodings.length;
            if ("identity".equalsIgnoreCase(transferEncodingHeader.getValue())) {
                entity.setChunked(false);
                entity.setContentLength(-1L);
                entity.setContent(new HttpDataInputStream(datareceiver));
            } else if (len > 0 && "chunked".equalsIgnoreCase(encodings[len - 1].getName())) {
                entity.setChunked(true);
                entity.setContentLength(-1L);
                entity.setContent(new ChunkedInputStream(datareceiver));
            } else {
                if (strict) {
                    throw new ProtocolException("Chunk-encoding must be the last one applied");
                }
                entity.setChunked(false);
                entity.setContentLength(-1L);
                entity.setContent(new HttpDataInputStream(datareceiver));
            }
        } else if (contentLengthHeader != null) {
            long contentlen = -1L;
            Header[] headers = message.getHeaders("Content-Length");
            if (strict && headers.length > 1) {
                throw new ProtocolException("Multiple content length headers");
            }
            for (int i = headers.length - 1; i >= 0; --i) {
                Header header = headers[i];
                try {
                    contentlen = Long.parseLong(header.getValue());
                    break;
                }
                catch (NumberFormatException e) {
                    if (!strict) continue;
                    throw new ProtocolException("Invalid content length: " + header.getValue());
                }
            }
            entity.setChunked(false);
            entity.setContentLength(contentlen);
            if (contentlen >= 0L) {
                entity.setContent(new ContentLengthInputStream(datareceiver, contentlen));
            } else {
                entity.setContent(new HttpDataInputStream(datareceiver));
            }
        } else {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new HttpDataInputStream(datareceiver));
        }
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if (contentEncodingHeader != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    public HttpEntity deserialize(HttpDataReceiver datareceiver, HttpMessage message) throws HttpException, IOException {
        return this.doDeserialize(datareceiver, message);
    }
}

