/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.io.HttpDataReceiver;

public class HttpDataInputStream
extends InputStream {
    private final HttpDataReceiver datareceiver;
    private boolean closed = false;

    public HttpDataInputStream(HttpDataReceiver datareceiver) {
        if (datareceiver == null) {
            throw new IllegalArgumentException("HTTP data receiver may not be null");
        }
        this.datareceiver = datareceiver;
    }

    public int available() throws IOException {
        if (!this.closed && this.datareceiver.isDataAvailable(10)) {
            return 1;
        }
        return 0;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        return this.datareceiver.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        return this.datareceiver.read(b, off, len);
    }
}

