/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.HttpVersion;
import org.apache.http.StatusLine;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.params.HttpProtocolParams;

public class BasicHttpResponse
extends AbstractHttpMessage
implements HttpResponse {
    private StatusLine statusline = null;
    private HttpEntity entity = null;

    public BasicHttpResponse() {
        this.setStatusCode(200);
    }

    public BasicHttpResponse(StatusLine statusline) {
        this.setStatusLine(statusline);
    }

    public HttpVersion getHttpVersion() {
        return this.statusline.getHttpVersion();
    }

    public StatusLine getStatusLine() {
        return this.statusline;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public void setStatusLine(StatusLine statusline) {
        if (statusline == null) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        this.statusline = statusline;
    }

    public void setStatusCode(int code) {
        if (code < 0) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        this.statusline = new StatusLine(HttpProtocolParams.getVersion(this.getParams()), code, HttpStatus.getStatusText(code));
    }

    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }
}

