/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.IOException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpServerConnection;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolException;
import org.apache.http.StatusLine;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.AbstractHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExecutionContext;

public class HttpService
extends AbstractHttpProcessor {
    private final HttpServerConnection conn;
    private final ConnectionReuseStrategy connStrategy;
    private final HttpContext context;
    private volatile boolean destroyed = false;
    private HttpParams params = null;

    public HttpService(HttpServerConnection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("HTTP server connection may not be null");
        }
        this.conn = conn;
        this.connStrategy = new DefaultConnectionReuseStrategy();
        this.context = new HttpExecutionContext(null);
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void setParams(HttpParams params) {
        this.params = params;
    }

    public boolean isActive() {
        return this.conn.isOpen();
    }

    protected void closeConnection() {
        try {
            this.conn.close();
        }
        catch (IOException ex) {
            this.logIOException(ex);
        }
    }

    public void handleRequest() {
        this.context.setAttribute("http.connection", this.conn);
        BasicHttpResponse response = new BasicHttpResponse();
        response.getParams().setDefaults(this.params);
        try {
            HttpEntity entity;
            HttpRequest request = this.conn.receiveRequestHeader(this.params);
            if (request instanceof HttpEntityEnclosingRequest) {
                if (((HttpEntityEnclosingRequest)request).expectContinue()) {
                    this.logMessage("Expected 100 (Continue)");
                    BasicHttpResponse ack = new BasicHttpResponse();
                    ack.getParams().setDefaults(this.params);
                    ack.setStatusCode(100);
                    this.conn.sendResponseHeader(ack);
                    this.conn.flush();
                }
                this.conn.receiveRequestEntity((HttpEntityEnclosingRequest)request);
            }
            this.preprocessRequest(request, this.context);
            this.logMessage("Request received");
            this.context.setAttribute("http.request", request);
            this.context.setAttribute("http.response", response);
            this.doService(request, response);
            if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
                entity.consumeContent();
            }
        }
        catch (ConnectionClosedException ex) {
            this.logMessage("Client closed connection");
            this.closeConnection();
            return;
        }
        catch (HttpException ex) {
            this.handleException(ex, response);
        }
        catch (IOException ex) {
            this.logIOException(ex);
            this.closeConnection();
            return;
        }
        try {
            this.postprocessResponse(response, this.context);
            this.conn.sendResponseHeader(response);
            this.conn.sendResponseEntity(response);
            this.conn.flush();
            this.logMessage("Response sent");
        }
        catch (HttpException ex) {
            this.logProtocolException(ex);
            this.closeConnection();
            return;
        }
        catch (IOException ex) {
            this.logIOException(ex);
            this.closeConnection();
            return;
        }
        if (!this.connStrategy.keepAlive(response)) {
            this.closeConnection();
        } else {
            this.logMessage("Connection kept alive");
        }
    }

    protected void handleException(HttpException ex, HttpResponse response) {
        if (ex instanceof MethodNotSupportedException) {
            response.setStatusCode(501);
        } else if (ex instanceof UnsupportedHttpVersionException) {
            response.setStatusCode(505);
        } else if (ex instanceof ProtocolException) {
            response.setStatusCode(400);
        } else {
            response.setStatusCode(500);
        }
    }

    protected void doService(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        HttpVersion ver = request.getRequestLine().getHttpVersion();
        if (ver.lessEquals(HttpVersion.HTTP_1_1)) {
            response.setStatusCode(501);
        } else {
            response.setStatusLine(new StatusLine(HttpVersion.HTTP_1_1, 501));
        }
    }

    protected void logMessage(String s) {
    }

    protected void logIOException(IOException ex) {
    }

    protected void logProtocolException(HttpException ex) {
    }

    public void destroy() {
        this.destroyed = true;
        try {
            this.conn.shutdown();
        }
        catch (IOException ex) {
            this.logIOException(ex);
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }
}

