/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.graph;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.mitre.lattice.graph.EllipseCell;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.lattice.LatticeTree;
import org.mitre.mrald.util.Config;

public class GraphFunctions {
    static Map<DefaultGraphCell, AttributeMap> attributes = new HashMap<DefaultGraphCell, AttributeMap>();
    static ConnectionSet cs = new ConnectionSet();
    static Set<Edge> edges = new HashSet<Edge>();
    static GraphModel model = null;
    static Map vertexEdges = new HashMap();
    static Map<String, DefaultGraphCell> vertices = new HashMap<String, DefaultGraphCell>();

    public static GraphModel setUpGraph() {
        model = new DefaultGraphModel();
        return model;
    }

    public static Object[] getAllVertices() {
        Object[] cells = new Object[vertices.size()];
        int i = 0;
        Iterator<DefaultGraphCell> iter = vertices.values().iterator();
        while (iter.hasNext()) {
            cells[++i] = iter.next();
        }
        return cells;
    }

    public static Object getRoot() {
        return vertices.get(LatticeTree.ROOT_LABEL);
    }

    public static Object getVertex(String label) {
        return vertices.get(label);
    }

    public static void addEdge(String source, String target) {
        GraphFunctions.addToModel(GraphFunctions.connectCells(target, source));
    }

    public static GraphCell addVertex(LatticeNode newNode) {
        EllipseCell vertex = Config.getLatticeFactory().createCell(newNode);
        vertex.add((MutableTreeNode)new DefaultPort());
        AttributeMap vertexAttrib = model.createAttributes();
        attributes.put(vertex, vertexAttrib);
        vertices.put(newNode.getName(), vertex);
        return vertex;
    }

    public static boolean containsEdge(String source, String target) {
        if (GraphFunctions.containsVertex(source) && GraphFunctions.containsVertex(target)) {
            if (!vertexEdges.containsKey(source)) {
                return false;
            }
            ArrayList edges = (ArrayList)vertexEdges.get(source);
            for (Edge e : edges) {
                if (!e.getTarget().equals(GraphFunctions.getPort(target))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsVertex(String label) {
        return vertices.containsKey(label);
    }

    private static Object getPort(String label) {
        DefaultGraphCell cell = vertices.get(label);
        return (DefaultPort)cell.getChildAt(0);
    }

    private static DefaultEdge addEdge() {
        DefaultEdge edge = new DefaultEdge();
        AttributeMap edgeAttrib = model.createAttributes();
        int arrow = 9;
        GraphConstants.setLineEnd((Map)edgeAttrib, (int)arrow);
        GraphConstants.setEndFill((Map)edgeAttrib, (boolean)true);
        GraphConstants.setLineColor((Map)edgeAttrib, (Color)Color.BLUE);
        edges.add((Edge)edge);
        attributes.put((DefaultGraphCell)edge, edgeAttrib);
        return edge;
    }

    private static void addToEdgeList(String source, Edge newEdge) {
        if (vertexEdges.containsKey(source)) {
            ArrayList edges = (ArrayList)vertexEdges.get(source);
            edges.add(newEdge);
        } else {
            ArrayList<Edge> edges = new ArrayList<Edge>();
            edges.add(newEdge);
        }
    }

    public static void addToModel(Object[] cells) {
        model.insert(cells, attributes, cs, null, null);
    }

    private static Object[] connectCells(String sourceName, String targetName) {
        DefaultEdge edge = GraphFunctions.addEdge();
        GraphFunctions.addToEdgeList(sourceName, (Edge)edge);
        cs.connect((Object)edge, GraphFunctions.getPort(sourceName), GraphFunctions.getPort(targetName));
        return new Object[]{edge, vertices.get(sourceName), vertices.get(targetName)};
    }
}

