/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.border.Border;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.layout.JGraphLayoutAlgorithm;
import org.jgraph.layout.SugiyamaLayoutAlgorithm;
import org.jgraph.util.JGraphUtilities;
import org.mitre.lattice.graph.CustomizableGraph;
import org.mitre.lattice.graph.EllipseCell;
import org.mitre.lattice.graph.GraphFunctions;
import org.mitre.lattice.graph.GraphSelect;
import org.mitre.lattice.graph.ImageConvertor;
import org.mitre.lattice.lattice.LatticeFunctions;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.util.Constants;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.User;

public class GraphLattice
extends JFrame {
    public static final String KEY = GraphLattice.class.getName();
    public static final Logger log = Logger.getLogger(KEY);
    static CustomizableGraph graph;
    Container contentPane;
    private static int screenWidth;
    private static int screenHeight;

    public GraphLattice() {
        log.entering(KEY, "init()");
        this.init();
    }

    public static JGraph getGraph() {
        log.entering(KEY, "getGraph()");
        return graph;
    }

    public static String convertToHtml(Object toImage, String name, String showLattice, User user) throws Exception {
        Image graphImage = ((Component)toImage).createImage(screenWidth, screenHeight);
        BufferedImage graphBImage = ImageConvertor.convertToBufferedImage(graphImage);
        FileOutputStream fos = new FileOutputStream(Config.getProperty("BasePath") + "/" + Config.getProperty("latticeGraph") + ".jsp");
        String header = "<%@ page errorPage=\"ErrorHandler.jsp\" %>\n<%@ page import=\"org.mitre.mrald.util.Config\" %>\n<%@ page import=\"org.mitre.mrald.util.User\" %>\n<%@ page import=\"org.mitre.lattice.graph.GraphSelect\" %>\n<%User user = (User)pageContext.getSession().getAttribute(Config.getProperty(\"cookietag\"));String graphName = GraphSelect.getLastGraph(user) + \".jpg\"; graphName = graphName.substring(graphName.indexOf(\"/\") + 1);%><!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<HTML>\n<HEAD>\n " + Config.getProperty("CSS") + "<META HTTP-EQUIV=\"CACHE-CONTROL\" CONTENT = \"NO-CACHE\">" + "</HEAD>\n<BODY>\n" + "<TABLE SUMMARY=\"\" WIDTH=\"100%\" BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">\n" + "<TR>\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tr>" + "<TD CLASS=\"bord\">\n<TABLE SUMMARY=\"\" WIDTH=\"100%\" BORDER=\"0\" CELLSPACING=\"1\" CELLPADDING=\"0\">\n" + "<TR><form ENCTYPE=\"x-www-form-urlencoded\" ACTION=\"../LatticePanel.jsp\" METHOD=\"POST\" target=\"groupList\">\n" + "<input type=\"hidden\" name=\"showLattice\" value=\"" + showLattice + "\">\n" + "<!--td width=\"12%\" class=\"nav\" onMouseOver=\"this.className='navhilite';\">Test</td-->\n" + "<TH><B><input name=\"ModifyNode\" value=\"Add\" type=\"submit\"></input></B></TH>\n" + "<TH><b><input name=\"ModifyNode\" value=\"Delete\" type=\"submit\"></input></b></th>\n" + "<TH><b><input name=\"ModifyNode\" value=\"Add Link\" type=\"submit\"></input></b></th>\n" + "<TH><b><input name=\"ModifyNode\" value=\"Delete Link\" type=\"submit\"></input></b></th>\n" + "<TH><b><input name=\"ModifyNode\" value=\"Focus\" type=\"submit\"></input></b></th>" + "<TH><b><input name=\"ModifyNode\" value=\"Unfocus\" type=\"submit\"></input></b></th>" + "</form><form ENCTYPE=\"x-www-form-urlencoded\" action=\"../latticePrefs.jsp\" METHOD=\"POST\"  target=\"groupList\"><TH><b>" + "<input name=\"Prefs\" value=\"Preferences\" type=\"submit\" ></input></b></th></form>" + "</TR>\n</TABLE>\n</TD>\n</TR>\n</TABLE>\n</TR>\n</TABLE>";
        String newGraph = GraphSelect.getLastGraph(user);
        newGraph = newGraph.substring(newGraph.indexOf("/") + 1);
        String imageTag = "<br><img src=\"<%=graphName%>\" width=\"" + graphBImage.getWidth() + "\" height=\"" + graphBImage.getHeight() + "\"" + " \border=\"0\" align=\"center\" ismap usemap=\"#map\"></form></body>";
        fos.write(header.getBytes());
        fos.write(imageTag.getBytes());
        fos.flush();
        fos.close();
        return header + imageTag;
    }

    public static String convertToHtml(User user) throws Exception {
        FileOutputStream fos = new FileOutputStream(Config.getProperty("BasePath") + "/" + Config.getProperty("latticeGraph") + ".jsp");
        String header = "<%@ page errorPage=\"ErrorHandler.jsp\" %>\n<%@ page import=\"org.mitre.mrald.util.Config\" %>\n<%@ page import=\"org.mitre.mrald.util.User\" %>\n<%@ page import=\"org.mitre.lattice.graph.GraphSelect\" %>\n<%User user = (User)pageContext.getSession().getAttribute(Config.getProperty(\"cookietag\"));String graphName = GraphSelect.getLastGraph(user) + \".jpg\"; graphName = graphName.substring(graphName.indexOf(\"/\") + 1);%><!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<HTML>\n<HEAD>\n " + Config.getProperty("CSS") + "<META HTTP-EQUIV=\"CACHE-CONTROL\" CONTENT = \"NO-CACHE\">" + "</HEAD>\n<BODY>\n" + "<TABLE SUMMARY=\"\" WIDTH=\"100%\" BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">\n" + "<TR>\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tr>" + "<TD CLASS=\"bord\">\n<TABLE SUMMARY=\"\" WIDTH=\"100%\" BORDER=\"0\" CELLSPACING=\"1\" CELLPADDING=\"0\">\n" + "<TR><form ENCTYPE=\"x-www-form-urlencoded\" ACTION=\"../LatticePanel.jsp\" METHOD=\"POST\" target=\"groupList\">\n" + "<input type=\"hidden\" name=\"showLattice\" value=\"true\">\n" + "<!--td width=\"12%\" class=\"nav\" onMouseOver=\"this.className='navhilite';\">Test</td-->\n" + "<TH><B><input name=\"ModifyNode\" value=\"Add\" type=\"submit\"></input></B></TH>\n" + "<TH><b><input name=\"ModifyNode\" value=\"Delete\" type=\"submit\"></input></b></th>\n" + "<TH><b><input name=\"ModifyNode\" value=\"Add Link\" type=\"submit\"></input></b></th>\n" + "<TH><b><input name=\"ModifyNode\" value=\"Delete Link\" type=\"submit\"></input></b></th>\n" + "<TH><b><input name=\"ModifyNode\" value=\"Focus\" type=\"submit\"></input></b></th>" + "<TH><b><input name=\"ModifyNode\" value=\"Unfocus\" type=\"submit\"></input></b></th>" + "</form><form ENCTYPE=\"x-www-form-urlencoded\" action=\"../latticePrefs.jsp\" METHOD=\"POST\"  target=\"groupList\"><TH><b>" + "<input name=\"Prefs\" value=\"Preferences\" type=\"submit\" ></input></b></th></form>" + "</TR>\n</TABLE>\n</TD>\n</TR>\n</TABLE>\n</TR>\n</TABLE>";
        String newGraph = GraphSelect.getLastGraph(user);
        newGraph = newGraph.substring(newGraph.indexOf("/") + 1);
        String imageTag = "<br><img src=\"<%=graphName%>\" width= " + screenWidth + " height=" + screenHeight + " border=\"0\" align=\"center\" ismap usemap=\"#map\"></form></body>";
        fos.write(header.getBytes());
        fos.write(imageTag.getBytes());
        fos.flush();
        fos.close();
        return header + imageTag;
    }

    public static void createImageFile(Object toImage, User user) throws Exception {
        log.entering(KEY, "createImageFile()");
        try {
            GraphSelect selectNew = new GraphSelect();
            String newGraph = selectNew.setNewGraph(user);
            String tempStr = Config.getProperty("BasePath") + "/" + newGraph;
            File graphFile = new File(tempStr + ".jpg");
            selectNew.cleanUp();
            log.finest("New graph picture info retrieved from database.");
            Image graphImage = ((Component)toImage).createImage(screenWidth, screenHeight);
            if (graphImage == null) {
                throw new MraldError("Graph Image is null. Could not create graph. ");
            }
            BufferedImage graphBImage = ImageConvertor.convertToBufferedImage(graphImage);
            log.finest("Frame converted to BufferedImage.");
            if (graphBImage == null) {
                throw new MraldError("BImage is NULL.  ImageConvertor failed.");
            }
            Graphics g = graphBImage.getGraphics();
            ((Component)toImage).paint(g);
            g.dispose();
            log.finest("BufferedImage painted.");
            log.finest("New graph file " + graphFile.getName() + " pointer created");
            ImageIO.write((RenderedImage)graphBImage.getSubimage(0, 0, 100, 100), "jpg", new File(Config.getProperty("BasePath") + "/test.jpg"));
            ImageIO.write((RenderedImage)graphBImage, "jpg", graphFile);
            log.finest("image file written.");
        }
        catch (IOException e) {
            throw new MraldError(e);
        }
        log.exiting(KEY, "createImageFile()");
    }

    public static void modelLattice(LatticeNode rootNode) {
        ArrayList<LatticeNode> thisPoint = new ArrayList<LatticeNode>();
        thisPoint.add(rootNode);
        if (!GraphFunctions.containsVertex(rootNode.getName())) {
            GraphCell cell = GraphFunctions.addVertex(rootNode);
            if (rootNode.countParentNodes() == 0) {
                GraphFunctions.addToModel(new Object[]{cell});
            }
        }
        for (int i = 0; i < rootNode.countParentNodes(); ++i) {
            LatticeNode parentNode = rootNode.getParents().get(i);
            if (!GraphFunctions.containsVertex(parentNode.getName())) {
                GraphFunctions.addVertex(parentNode);
            }
            if (!GraphFunctions.containsEdge(rootNode.getName(), parentNode.getName())) {
                GraphFunctions.addEdge(rootNode.getName(), parentNode.getName());
            }
            GraphLattice.modelLattice(parentNode);
        }
    }

    public void graphSolution(Object[] xPoints, Object[] yPoints) {
        log.finest("About to get modelLattice.");
        GraphLattice.modelLattice(LatticeFunctions.getRootNode());
        log.finest("Finished with modelLattice.");
        int noOfGenes = xPoints.length;
        for (int i = noOfGenes - 1; i > -1; --i) {
            int xPos = (Integer)xPoints[i];
            int yPos = (Integer)yPoints[i];
            LatticeNode node = LatticeFunctions.getNode(new Integer(i));
            this.positionVertex(node, xPos, yPos);
        }
        Object[] cells = graph.getRoots();
        if (cells.length > 0) {
            graph.getGraphLayoutCache().getMapping(cells[0], false).refresh(false);
        }
        log.finest("Creating legend.");
        this.createLegend();
        log.finest("Createdlegend.");
        graph.graphDidChange();
        graph.getGraphLayoutCache().reload();
    }

    public void graphSolution() {
        GraphLattice.modelLattice(LatticeFunctions.getRootNode());
        Object[] cells = graph.getRoots();
        this.setGraphConstants(cells);
        graph.setPreferredSize(AbstractCellView.getBounds((CellView[])graph.getGraphLayoutCache().getMapping(cells)).getBounds().getSize());
        JGraphUtilities.applyLayout((JGraph)graph, (JGraphLayoutAlgorithm)new SugiyamaLayoutAlgorithm());
        if (cells.length > 0) {
            graph.getGraphLayoutCache().getMapping(cells[0], false).refresh(false);
        }
        this.createLegend();
        graph.graphDidChange();
        graph.getGraphLayoutCache().reload();
    }

    public void init() {
        log.finest("Graph Lattice: starting init");
        this.contentPane = this.getContentPane();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        log.finest("About to get customizable graph");
        graph = new CustomizableGraph(GraphFunctions.setUpGraph());
        Properties props = CustomizableGraph.LATTICE_PROPS;
        screenWidth = Integer.parseInt(props.getProperty("ScreenWidth"));
        screenHeight = Integer.parseInt(props.getProperty("ScreenHeight"));
        log.finest("About to setSelectNewCells");
        graph.setSelectNewCells(false);
        String[] bckGround = props.getProperty("graphBackground").split(",");
        Color bckGroundCol = new Color(Integer.parseInt(bckGround[0]), Integer.parseInt(bckGround[1]), Integer.parseInt(bckGround[2]));
        log.finest("About to get dimensions");
        Dimension dim = new Dimension(screenWidth, screenHeight);
        graph.setBackground(bckGroundCol);
        graph.setPortsVisible(false);
        graph.setMinimumSize(dim);
        this.contentPane.add((Component)((Object)graph), "Center");
        this.pack();
        log.finest("Finished init");
    }

    public void positionVertex(LatticeNode root, int x, int y) {
        this.positionVertexAt(root.getName(), x, y);
    }

    private int sizeVertex() {
        if (LatticeFunctions.getBoxWidth() < LatticeFunctions.getWidth() / 10) {
            return LatticeFunctions.getBoxWidth() * 7 / 8;
        }
        return Integer.parseInt(CustomizableGraph.LATTICE_PROPS.getProperty("MaxCellWidth"));
    }

    private void setGraphConstants(Object[] cells) {
        for (int i = 0; i < cells.length; ++i) {
            DefaultGraphCell cell = (DefaultGraphCell)cells[i];
            AttributeMap attr = cell.getAttributes();
            this.setGraphConstants((Map)attr, 0, 0);
        }
    }

    private Map setGraphConstants(Map attr, int x, int y) {
        Properties props = CustomizableGraph.LATTICE_PROPS;
        int width = this.sizeVertex();
        GraphConstants.setBounds((Map)attr, (Rectangle2D)new Rectangle(x, y, width, width * 25 / 45));
        Font font = new Font(props.getProperty("FontName"), (int)new Integer(props.getProperty("FontStyle")), new Integer(props.getProperty("FontSize")));
        GraphConstants.setBorder((Map)attr, (Border)BorderFactory.createRaisedBevelBorder());
        GraphConstants.setOpaque((Map)attr, (boolean)true);
        String[] backGroundInts = props.getProperty("Background").split(",");
        Color backGroundCol = new Color(Integer.parseInt(backGroundInts[0]), Integer.parseInt(backGroundInts[1]), Integer.parseInt(backGroundInts[2]));
        GraphConstants.setBackground((Map)attr, (Color)backGroundCol);
        GraphConstants.setFont((Map)attr, (Font)font);
        GraphConstants.setLineStyle((Map)attr, (int)13);
        return attr;
    }

    private void positionVertexAt(Object vertex, int x, int y) {
        DefaultGraphCell cell = (DefaultGraphCell)GraphFunctions.getVertex(vertex.toString());
        AttributeMap attr = cell.getAttributes();
        HashMap<DefaultGraphCell, Map> cellAttr = new HashMap<DefaultGraphCell, Map>();
        cellAttr.put(cell, this.setGraphConstants((Map)attr, x, y));
    }

    private void createLegend() {
        String[] nodeTypes = Constants.getNodeTypes();
        ArrayList<EllipseCell> cells = new ArrayList<EllipseCell>();
        HashMap<EllipseCell, AttributeMap> attributes = new HashMap<EllipseCell, AttributeMap>();
        int x = 0;
        int y = screenHeight - new Double((double)LatticeFunctions.getBoxHeight() * 0.5).intValue();
        int width = this.sizeVertex();
        if (width > 120) {
            width = 120;
        }
        for (int i = 0; i < nodeTypes.length; ++i) {
            EllipseCell vertex = Config.getLatticeFactory().createCell(nodeTypes[i], nodeTypes[i]);
            AttributeMap vertexAttrib = graph.getModel().createAttributes();
            x = LatticeFunctions.getBoxWidth() * 2 / 3;
            if (x > 150) {
                x = 150;
            }
            this.setGraphConstants((Map)vertexAttrib, x *= i, y);
            GraphConstants.setBounds((Map)vertexAttrib, (Rectangle2D)new Rectangle(x, y, width * 2 / 3, width * 16 / 45));
            cells.add(vertex);
            attributes.put(vertex, vertexAttrib);
        }
        graph.getModel().insert(cells.toArray(), attributes, new ConnectionSet(), null, null);
    }

    static {
        log.setLevel(Level.FINEST);
        graph = null;
        screenWidth = 0;
        screenHeight = 0;
    }
}

