/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.graph;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mitre.lattice.graph.GraphLattice;
import org.mitre.lattice.graph.MinimizingDistance;
import org.mitre.lattice.graph.SampleLattices;
import org.mitre.lattice.lattice.InsufficentGroupAccessException;
import org.mitre.lattice.lattice.InvalidLatticeStructureException;
import org.mitre.lattice.lattice.LatticeElement;
import org.mitre.lattice.lattice.LatticeErrorHandler;
import org.mitre.lattice.lattice.LatticeException;
import org.mitre.lattice.lattice.LatticeFunctions;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.lattice.LatticeTree;
import org.mitre.lattice.lattice.LatticeUserGroup;
import org.mitre.lattice.lattice.MultipleParentsException;
import org.mitre.lattice.lattice.NodeNotFoundException;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.MsgObjectException;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.FileUtils;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;

public class GraphUserLattice
extends AbstractStep {
    public static final String KEY = GraphUserLattice.class.getName();
    public static final Logger log = Logger.getLogger(KEY);
    private LatticeException latticeErr = null;
    private String keyGroup = null;
    private String[] userGroups = null;
    private static LatticeTree lattice;

    public void graphLatticeNonGeneric(MsgObject msg) throws WorkflowStepException, MraldException {
        try {
            LatticeFunctions.setImplmnt();
            String[] showLattice = msg.getValue("showLattice");
            boolean showWholeLattice = true;
            if (showLattice[0].equals("")) {
                showWholeLattice = false;
            }
            LatticeTree newLattice = (LatticeTree)GraphUserLattice.getLattice();
            LatticeTree childTree = null;
            HttpServletRequest req = msg.getReq();
            HttpSession ses = req.getSession();
            LatticeUserGroup userGroup = null;
            User user = null;
            if (ses == null) {
                HttpServletResponse resp = msg.getRes();
                resp.sendRedirect(Config.getProperty("BaseUrl") + "/LatticeLogin.jsp?pageurl=" + req.getRequestURL());
                return;
            }
            user = (User)ses.getAttribute(Config.getProperty("cookietag"));
            userGroup = new LatticeUserGroup(user.getGroup());
            ArrayList<ParserElement> latticeElements = msg.getWorkingObjects();
            try {
                this.keyGroup = user.getGroup();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            newLattice = (LatticeTree)this.processElements(latticeElements, newLattice);
            if (!this.keyGroup.equals("")) {
                userGroup.setUserGroups(this.userGroups);
                String keyNodeStr = userGroup.getMostDominant(newLattice.getRootNode());
                LatticeNode key = newLattice.searchTree(keyNodeStr);
                if (!showWholeLattice) {
                    if (key != newLattice.getRootNode()) {
                        childTree = new LatticeTree((LatticeNode)LatticeFunctions.getChildTree(key));
                        if (childTree == null || childTree.getRootNode() == null) {
                            throw new InsufficentGroupAccessException("You have insufficent privilidges to access this system. Please contact your system Administrator..");
                        }
                    } else {
                        childTree = new LatticeTree(Config.getLatticeFactory().copyNode(key));
                    }
                }
                GraphLattice newGraph = new GraphLattice();
                newGraph.graphSolution();
                GraphLattice.createImageFile(GraphLattice.getGraph(), user);
                String output = GraphLattice.convertToHtml(GraphLattice.getGraph(), Config.getProperty("latticeGraph"), showLattice[0], user);
                GraphUserLattice.outputHtml(msg, output);
                GraphUserLattice.storeLattice(newLattice);
            } else {
                this.latticeErr = new InsufficentGroupAccessException("LATT-003");
            }
        }
        catch (LatticeException e) {
            this.latticeErr = e;
        }
        catch (ServletException e) {
            throw new WorkflowStepException(e);
        }
        catch (IOException e) {
            throw new WorkflowStepException(e);
        }
        catch (MsgObjectException e) {
            throw new WorkflowStepException(e);
        }
        catch (Exception e) {
            throw new WorkflowStepException(e);
        }
    }

    public void graphLattice(MsgObject msg) throws WorkflowStepException, MraldException {
        try {
            if (!Config.getLatticeFactory().getUsingLatticeSecurityModel()) {
                this.latticeErr = new LatticeException("The Lattice Security Model is currently disabled. Please contact your system Administrator if you require Lattice Security to be enabled. ");
            }
        }
        catch (LatticeException e) {
            this.latticeErr = e;
            throw e;
        }
        try {
            log.entering(KEY, "graphLattice(MsgObject)");
            LatticeFunctions.setImplmnt();
            String[] showLattice = msg.getValue("showLattice");
            boolean showWholeLattice = true;
            if (showLattice[0].equals("")) {
                showWholeLattice = false;
            }
            log.finest("About to start MinimizingDistance");
            LatticeTree newLattice = (LatticeTree)GraphUserLattice.getLattice();
            log.finest("Lattice retrieved");
            LatticeTree childTree = null;
            HttpServletRequest req = msg.getReq();
            HttpSession ses = req.getSession();
            LatticeUserGroup userGroup = null;
            User user = null;
            if (ses == null) {
                HttpServletResponse resp = msg.getRes();
                resp.sendRedirect(Config.getProperty("BaseUrl") + "/LatticeLogin.jsp?pageurl=" + req.getRequestURL());
                return;
            }
            user = (User)ses.getAttribute(Config.getProperty("cookietag"));
            userGroup = new LatticeUserGroup(user.getGroup());
            ArrayList<ParserElement> latticeElements = msg.getWorkingObjects();
            try {
                this.keyGroup = user.getGroup();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            log.finest("About to process elements (add, delete, etc.");
            newLattice = (LatticeTree)this.processElements(latticeElements, newLattice);
            if (!this.keyGroup.equals("")) {
                log.finest("COI assigned: " + this.keyGroup);
                userGroup.setUserGroups(this.userGroups);
                String keyNodeStr = userGroup.getMostDominant(newLattice.getRootNode());
                LatticeNode key = newLattice.searchTree(keyNodeStr);
                if (!showWholeLattice) {
                    if (key != newLattice.getRootNode()) {
                        childTree = new LatticeTree((LatticeNode)LatticeFunctions.getChildTree(key));
                        if (childTree == null || childTree.getRootNode() == null) {
                            throw new InsufficentGroupAccessException("You have insufficent privilidges to access this system. Please contact your system Administrator..");
                        }
                    } else {
                        childTree = new LatticeTree(Config.getLatticeFactory().copyNode(key));
                    }
                    childTree = new LatticeTree((LatticeNode)LatticeFunctions.getSubTree(childTree, newLattice.getRootNode()));
                    MinimizingDistance.setLatticeTree(childTree);
                } else {
                    MinimizingDistance.setLatticeTree(newLattice);
                }
                Object[] solnPoints = MinimizingDistance.calcDistance();
                log.finest("About to creat Graph Lattice");
                GraphLattice newGraph = new GraphLattice();
                log.finest("Success: created GraphLattice");
                newGraph.graphSolution((Object[])solnPoints[0], (Object[])solnPoints[1]);
                log.finest("Dumping a new image file");
                GraphLattice.createImageFile(GraphLattice.getGraph(), user);
                String output = GraphLattice.convertToHtml(GraphLattice.getGraph(), Config.getProperty("latticeGraph"), showLattice[0], user);
                log.finest("sending HTML to the client");
                GraphUserLattice.outputHtml(msg, output);
            } else {
                log.finest("No COI assigned - need to go log in");
                this.latticeErr = new InsufficentGroupAccessException("LATT-003: You have insufficent privilidges to access this system. Please contact your system Administrator..");
            }
            log.exiting(KEY, "graphLattice(MsgObject)");
        }
        catch (LatticeException e) {
            this.latticeErr = e;
        }
        catch (ServletException e) {
            throw new WorkflowStepException(e);
        }
        catch (IOException e) {
            throw new WorkflowStepException(e);
        }
        catch (MsgObjectException e) {
            throw new WorkflowStepException(e);
        }
        catch (Exception e) {
            throw new WorkflowStepException(e);
        }
    }

    public static void resetLattice() throws MraldException {
        lattice = null;
    }

    public static Object getLattice() throws MraldException {
        try {
            log.info("Checking to see if the lattice tree file is null");
            if (lattice == null) {
                String fileName = Config.getProperty("LatticeFile");
                log.info("About to get the lattice tree file");
                lattice = LatticeFunctions.recoverLatticeTree(fileName);
                if (lattice != null) {
                    log.info("Got old lattice file");
                    return lattice;
                }
                log.info("Got completely new lattice file");
                return SampleLattices.buildNewLattice();
            }
            log.info("Returning the Lattice Tree from memory");
            return lattice;
        }
        catch (FileNotFoundException e) {
            log.log(Level.INFO, "Serialized lattice file wasn't found.  The lattice file is being blow away.", e);
            return SampleLattices.buildNewLattice();
        }
        catch (IOException e) {
            log.log(Level.INFO, "Other IO problem.  The lattice file is being blow away.", e);
            return SampleLattices.buildNewLattice();
        }
    }

    public static void storeLattice(Object lattice) throws MraldException {
        try {
            boolean created;
            String filename = Config.getProperty("LatticeFile");
            String latticeDir = filename.substring(0, filename.lastIndexOf("/"));
            if (!new File(latticeDir).exists() && !(created = new File(latticeDir).mkdirs())) {
                throw new IOException("Couldn't create the directory \"" + latticeDir + "\".  Check your file system, though, some intermediate directories may have been created");
            }
            if (!new File(filename).exists() && !(created = new File(Config.getProperty("LatticeFile")).createNewFile())) {
                throw new IOException("Couldn't create the directory \"" + Config.getProperty("LatticeFile") + "\".  Check your file system, though, some intermediate directories may have been created");
            }
            GraphUserLattice.backupLattice(filename);
            LatticeFunctions.serializeLatticeTree((LatticeTree)lattice, filename);
        }
        catch (IOException ioe) {
            throw new MraldException(ioe.getMessage());
        }
    }

    public static void backupLattice(String filename) throws MraldException {
        try {
            String latticeFile = Config.getProperty("LatticeFile");
            String fileName = latticeFile.substring(latticeFile.lastIndexOf("/"));
            String latticeDir = latticeFile.substring(0, latticeFile.lastIndexOf("/"));
            String backupDir = latticeDir + "/backup/last";
            FileUtils fileUtils = new FileUtils();
            fileUtils.backupFile(latticeFile, backupDir + "/" + fileName);
            Calendar now = Calendar.getInstance();
            int month = new Integer(now.get(2)) + 1;
            String dateDirectory = month + "_" + now.get(5) + "_" + now.get(1);
            dateDirectory = latticeDir + "/backup/" + dateDirectory;
            fileUtils.backupFile(latticeFile, dateDirectory + "/" + fileName);
        }
        catch (Exception e) {
            throw new MraldException(e.getMessage());
        }
    }

    public static Object deleteNode(ArrayList deleteNodes, Object lattice) throws NodeNotFoundException, LatticeException, MultipleParentsException, InvalidLatticeStructureException {
        if (deleteNodes.size() == 0) {
            return lattice;
        }
        LatticeElement elem = (LatticeElement)deleteNodes.get(0);
        MsgObject deleteMsg = elem.getNameValues();
        String[] deleteParents = deleteMsg.getValue("deleteGroup");
        for (int i = 0; i < deleteParents.length; ++i) {
            String parentStr = deleteParents[i];
            LatticeNode deleteNode = ((LatticeTree)lattice).searchTree(parentStr);
            ArrayList<LatticeNode> parents = deleteNode.getParents();
            if (parents.size() > 1) {
                throw new MultipleParentsException("LATT-001");
            }
            for (int j = 0; j < parents.size(); ++j) {
                LatticeNode parent = parents.get(j);
                parent.removeChild(deleteNode);
                parent.reAssignChild(deleteNode);
            }
            ArrayList<LatticeNode> children = deleteNode.getChildren();
            for (int k = 0; k < children.size(); ++k) {
                LatticeNode child = children.get(k);
                child.removeParent(deleteNode);
            }
            deleteNode = null;
        }
        return lattice;
    }

    public Object processElements(ArrayList latticeElements, Object lattice) throws NodeNotFoundException, InvalidLatticeStructureException, LatticeException, MraldException {
        LatticeTree newLattice = (LatticeTree)lattice;
        ArrayList<LatticeElement> viewElements = new ArrayList<LatticeElement>();
        ArrayList<LatticeElement> addElements = new ArrayList<LatticeElement>();
        ArrayList<LatticeElement> deleteElements = new ArrayList<LatticeElement>();
        ArrayList<LatticeElement> deleteLinkElements = new ArrayList<LatticeElement>();
        for (int i = 0; i < latticeElements.size(); ++i) {
            LatticeElement latticeElem = (LatticeElement)latticeElements.get(i);
            String type = latticeElem.getNameValues().getValue("Type")[0];
            if (type.equals("Add")) {
                addElements.add(latticeElem);
                continue;
            }
            if (type.equals("Delete")) {
                deleteElements.add(latticeElem);
                continue;
            }
            if (type.equals("DeleteLink")) {
                deleteLinkElements.add(latticeElem);
                continue;
            }
            if (type.equals("securityGroup")) {
                viewElements.add(latticeElem);
                continue;
            }
            addElements.add(latticeElem);
        }
        newLattice = (LatticeTree)this.addNode(addElements, newLattice);
        newLattice = (LatticeTree)GraphUserLattice.deleteNode(deleteElements, newLattice);
        newLattice = (LatticeTree)GraphUserLattice.deleteLink(deleteLinkElements, newLattice);
        this.keyGroup = this.getKeyGroup(viewElements);
        log.finest("Storing the lattice file");
        GraphUserLattice.storeLattice(newLattice);
        return newLattice;
    }

    public String getKeyGroup(ArrayList viewElements) {
        for (int i = 0; i < viewElements.size(); ++i) {
            LatticeElement lattElem = (LatticeElement)viewElements.get(i);
            this.userGroups = lattElem.getNameValues().getValue("securityGroup");
        }
        if (this.userGroups == null) {
            this.userGroups = new String[]{this.keyGroup};
            return this.keyGroup;
        }
        if (this.userGroups.length > 0) {
            this.keyGroup = this.userGroups[0];
        }
        return this.keyGroup;
    }

    public static Object deleteLink(ArrayList deleteLinks, Object lattice) throws NodeNotFoundException, InvalidLatticeStructureException {
        MsgObject deleteMsg = null;
        LatticeTree latticeTree = (LatticeTree)lattice;
        if (latticeTree.getRootNode().equals(latticeTree.searchTree("Public"))) {
            // empty if block
        }
        for (int i = 0; i < deleteLinks.size(); ++i) {
            LatticeElement latticeElem = (LatticeElement)deleteLinks.get(i);
            deleteMsg = latticeElem.getNameValues();
            String parent = deleteMsg.getValue("Parent")[0];
            LatticeNode deleteNode = latticeTree.searchTree(parent);
            String childName = deleteMsg.getValue("Child")[0];
            LatticeNode child = latticeTree.searchTree(childName);
            if (child.equals(latticeTree.getRootNode())) {
                throw new InvalidLatticeStructureException("LATT-006", "");
            }
            child.getParents().remove(deleteNode);
            if (deleteNode.reAssignChild(child)) continue;
            deleteNode.reAssignParentsToPublic(latticeTree.getRootNode());
        }
        return lattice;
    }

    public Object addNode(ArrayList addNodes, Object lattice) throws NodeNotFoundException, InvalidLatticeStructureException, MraldException {
        if (addNodes.size() == 0) {
            return lattice;
        }
        boolean childAdded = false;
        boolean parentAdded = false;
        boolean isNewNode = true;
        LatticeNode newNode = null;
        LatticeTree latticeTree = (LatticeTree)lattice;
        LatticeElement elem = (LatticeElement)addNodes.get(0);
        MsgObject addMsg = elem.getNameValues();
        String newNodeName = addMsg.getValue("Value")[0];
        if (newNodeName == "") {
            newNodeName = addMsg.getValue("addNode")[0];
        }
        try {
            newNode = latticeTree.searchTree(newNodeName);
            isNewNode = false;
        }
        catch (NodeNotFoundException e) {
            newNode = Config.getLatticeFactory().createNode(newNodeName);
            log.info(" Node creation here : " + newNodeName + " no type ");
            newNode = this.setCustomizable(addMsg, newNode);
        }
        String[] children = addMsg.getValue("Child");
        for (int i = 0; i < children.length; ++i) {
            String childName = children[i];
            if (childName.equals("")) continue;
            LatticeNode childKey = latticeTree.searchTree(childName);
            if (childKey.addParent(newNode)) {
                childAdded = newNode.addChild(childKey);
            }
            if (!childAdded) continue;
            latticeTree.removeCyclic(childKey, newNode);
        }
        if (!childAdded && isNewNode) {
            LatticeNode childKey = latticeTree.searchTree("Public");
            if (childKey.addParent(newNode)) {
                childAdded = newNode.addChild(childKey);
            }
            if (childAdded) {
                latticeTree.removeCyclic(childKey, newNode);
            }
        }
        String[] addParents = addMsg.getValue("Parent");
        for (int i = 0; i < addParents.length; ++i) {
            String parentName = addParents[i];
            if (parentName.equals("")) continue;
            LatticeNode parentKey = latticeTree.searchTree(parentName);
            if (parentKey.addChild(newNode)) {
                parentAdded = newNode.addParent(parentKey);
            }
            if (!parentAdded) continue;
            latticeTree.removeCyclicChild(parentKey, newNode);
        }
        GraphUserLattice.addToLatticeGroups(new String[]{newNodeName});
        return latticeTree;
    }

    public static void addToLatticeGroups(String[] newNodes) throws MraldException {
        try {
            MraldConnection conn = new MraldConnection(MetaData.ADMIN_DB);
            String selectStr = "select latticegroupid from latticegroup ";
            ResultSet rs = conn.executeQuery(selectStr);
            ArrayList<String> cois = new ArrayList<String>();
            while (rs.next()) {
                cois.add(rs.getString(1));
            }
            String updateStatement = "INSERT INTO latticegroup values( '<:groupid:>', '<:groupName:>', '')";
            for (int i = 0; i < newNodes.length; ++i) {
                if (newNodes[i].equals("") || cois.contains(newNodes[i])) continue;
                String coi = MiscUtils.checkApostrophe(MiscUtils.checkApostrophe(newNodes[i]));
                updateStatement = updateStatement.replaceAll("<:groupid:>", coi);
                updateStatement = updateStatement.replaceAll("<:groupName:>", coi);
                conn.executeUpdate(updateStatement);
            }
            conn.close();
        }
        catch (Exception e) {
            MraldException me = new MraldException(e.getMessage());
            throw me;
        }
    }

    public static void outputHtml(MsgObject msg, String output) throws ServletException, IOException, MsgObjectException {
        HttpServletResponse res = msg.getRes();
        res.sendRedirect(Config.getProperty("BaseUrl") + "/LatticeManagement.jsp");
    }

    public static void main(String[] args) {
    }

    public void execute(MsgObject msg) throws WorkflowStepException {
        try {
            this.graphLattice(msg);
            if (this.latticeErr != null) {
                LatticeErrorHandler.handleException(msg, this.latticeErr, true);
            }
        }
        catch (Exception e) {
            throw new WorkflowStepException(e);
        }
    }

    public LatticeNode setCustomizable(MsgObject msg, LatticeNode newNode) {
        log.info("Node type is: None ");
        return newNode;
    }

    static {
        log.setLevel(Level.FINEST);
        lattice = null;
    }
}

