/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.graph;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldOutFile;

public class ImageConvertor {
    public static BufferedImage convertToBufferedImage(Image image) {
        try {
            GraphicsDevice gs;
            GraphicsConfiguration gc;
            if (image == null) {
                return null;
            }
            BufferedImage bimage = null;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (GraphicsEnvironment.isHeadless()) {
                MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "Running in Graphics Headless Mode ");
            }
            if (image instanceof BufferedImage) {
                return (BufferedImage)image;
            }
            image = new ImageIcon(image).getImage();
            boolean hasAlpha = ImageConvertor.hasAlpha(image);
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            if ((bimage = (gc = (gs = ge.getDefaultScreenDevice()).getDefaultConfiguration()).createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency)) == null) {
                int type = 1;
                if (hasAlpha) {
                    type = 2;
                }
                bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
            }
            Graphics2D g = bimage.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            return bimage;
        }
        catch (HeadlessException e) {
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "Headless Mode ");
        }
        catch (Exception e) {
            throw new MraldError(e);
        }
        return null;
    }

    public static boolean hasAlpha(Image image) {
        return false;
    }
}

