/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.graph;

import java.util.ArrayList;
import org.jgap.Chromosome;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.impl.IntegerGene;
import org.mitre.lattice.lattice.LatticeFunctions;
import org.mitre.lattice.lattice.LatticeNode;

public class MinDistanceFitness
extends FitnessFunction {
    public double maxDistance = 0.0;
    public static boolean isTest = true;
    public static int testValue = 0;

    public MinDistanceFitness(double maxDist) {
        this.maxDistance = maxDist;
    }

    public int evaluate(Chromosome a_subject) {
        int distance = this.pullPointsTogether(a_subject);
        int fitness2 = MinDistanceFitness.pushPointsApart(a_subject);
        int fitness = (int)(this.maxDistance - (double)distance) + fitness2;
        if (!isTest) {
            fitness -= testValue;
        }
        if (fitness < 1) {
            return 1;
        }
        return fitness;
    }

    private int pullPointsTogether(Chromosome a_subject) {
        double distance = 0.0;
        for (int i = 0; i < a_subject.getGenes().length; ++i) {
            LatticeNode node = LatticeFunctions.getNode(new Integer(i));
            ArrayList<LatticeNode> parents = node.getParents();
            IntegerGene gene = (IntegerGene)a_subject.getGene(i);
            int x1 = gene.intValue();
            int levelChild = LatticeFunctions.getLevelOfNode(node);
            for (int j = 0; j < parents.size(); ++j) {
                LatticeNode parentNode = parents.get(j);
                int geneNo = LatticeFunctions.getInteger(parentNode);
                IntegerGene gene2 = (IntegerGene)a_subject.getGene(geneNo);
                int x2 = gene2.intValue();
                int levelParent = LatticeFunctions.getLevelOfNode(parentNode);
                int deltaY = (levelParent - levelChild) * LatticeFunctions.getBoxHeight();
                distance += LatticeFunctions.getDistanceBetweenNodes(x1, x2, deltaY);
            }
        }
        return (int)distance;
    }

    public static void setNotTest() {
        isTest = false;
    }

    public static void setTestValue(int test) {
        testValue = test;
    }

    public static int pushPointsApart(Chromosome a_potentialSolution) {
        int fitness = 0;
        int numberOfGenes = a_potentialSolution.size();
        Gene[] allGenes = a_potentialSolution.getGenes();
        for (int i = 0; i < numberOfGenes; ++i) {
            LatticeNode node = LatticeFunctions.getNode(new Integer(i));
            ArrayList nodesOnThisLevel = LatticeFunctions.getNodesOnSameLevel(node);
            for (int j = 0; j < nodesOnThisLevel.size(); ++j) {
                int minDist;
                int geneIndex = (Integer)nodesOnThisLevel.get(j);
                if (geneIndex == i || !((double)(minDist = ((IntegerGene)allGenes[i]).intValue() - ((IntegerGene)allGenes[geneIndex]).intValue()) > 0.5 * (double)LatticeFunctions.getBoxWidth())) continue;
                fitness += LatticeFunctions.getBoxHeight() * 2;
            }
        }
        return fitness;
    }

    public static double getDistanceAtGene(Chromosome a_potentialSolution, int a_position) {
        Integer xCoord = (Integer)a_potentialSolution.getGene(a_position).getAllele();
        return xCoord.doubleValue();
    }

    public static int getTotalDistance(Chromosome a_potentialsolution) {
        int totalDistance = 0;
        int numberOfGenes = a_potentialsolution.size();
        for (int i = 0; i < numberOfGenes; ++i) {
            totalDistance = (int)((double)totalDistance + MinDistanceFitness.getDistanceAtGene(a_potentialsolution, i));
        }
        return totalDistance;
    }
}

