/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.graph;

import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.InvalidConfigurationException;
import org.jgap.impl.DefaultConfiguration;
import org.jgap.impl.IntegerGene;
import org.mitre.lattice.graph.GraphUserLattice;
import org.mitre.lattice.graph.MinDistanceFitness;
import org.mitre.lattice.lattice.LatticeFunctions;
import org.mitre.lattice.lattice.LatticeTree;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldOutFile;

public class MinimizingDistance {
    private static final int MAX_ALLOWED_EVOLUTIONS = 50;
    private static int maxDistance = 0;
    private static LatticeTree latticeTree = null;

    public static void main(String[] args) {
        try {
            LatticeTree newLattice = (LatticeTree)GraphUserLattice.getLattice();
            MinimizingDistance.setLatticeTree(newLattice);
            MinimizingDistance.calcDistance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object[] calcDistance() throws Exception {
        DefaultConfiguration conf = new DefaultConfiguration();
        Gene[] sampleGenes = MinimizingDistance.initialize();
        MinDistanceFitness myFunc = new MinDistanceFitness(maxDistance);
        conf.setFitnessFunction((FitnessFunction)myFunc);
        Chromosome sampleChromosome = new Chromosome(sampleGenes);
        conf.setSampleChromosome(sampleChromosome);
        conf.setPopulationSize(500);
        Genotype population = Genotype.randomInitialGenotype((Configuration)conf);
        MinimizingDistance.runTest((Configuration)conf, myFunc);
        int maxFitnessValue = 0;
        Chromosome bestSolutionSoFar = null;
        for (int i = 0; i < 50; ++i) {
            population.evolve();
            if (population.getFittestChromosome().getFitnessValue() <= maxFitnessValue) continue;
            maxFitnessValue = population.getFittestChromosome().getFitnessValue();
            bestSolutionSoFar = (Chromosome)population.getFittestChromosome().clone();
        }
        return MinimizingDistance.getPointsOfSolution(bestSolutionSoFar);
    }

    public static void setLatticeTree(LatticeTree setTree) {
        latticeTree = setTree;
        LatticeFunctions.setIsSet(false);
    }

    public static LatticeTree getLatticeTree() {
        return latticeTree;
    }

    public static Object[] graphSolution(Chromosome bestSol) {
        int noOfGenes = bestSol.getGenes().length;
        Object[] xPoints = new Object[noOfGenes];
        Object[] yPoints = new Object[noOfGenes];
        for (int i = noOfGenes - 1; i > -1; --i) {
            xPoints[i] = new Integer((int)MinDistanceFitness.getDistanceAtGene(bestSol, i));
            yPoints[i] = new Integer(LatticeFunctions.getY(new Integer(i)));
        }
        return new Object[]{xPoints, yPoints};
    }

    private static Object[] getPointsOfSolution(Chromosome bestSolutionSoFar) {
        try {
            LatticeFunctions.spaceOutLevels(bestSolutionSoFar.getGenes());
            return MinimizingDistance.graphSolution(bestSolutionSoFar);
        }
        catch (Exception e) {
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), e.getStackTrace());
            return null;
        }
    }

    private static Gene[] initialize() {
        LatticeTree newLattice = MinimizingDistance.getLatticeTree();
        int noOfNodes = LatticeFunctions.initialize(newLattice.getRootNode());
        maxDistance = LatticeFunctions.calcMaxDistance();
        Gene[] sampleGenes = new Gene[noOfNodes];
        sampleGenes[0] = new IntegerGene(LatticeFunctions.getScreenWidth() / 2, LatticeFunctions.getScreenWidth() / 2 + 1);
        for (int i = 0; i < noOfNodes - 1; ++i) {
            sampleGenes[i + 1] = new IntegerGene(0, LatticeFunctions.getScreenWidth());
        }
        return sampleGenes;
    }

    private static void runTest(Configuration conf, FitnessFunction myFunc) throws InvalidConfigurationException {
        Genotype testPopulation = Genotype.randomInitialGenotype((Configuration)conf);
        testPopulation.evolve();
        int maxFitnessValue = 0;
        for (int i = 0; i < 5; ++i) {
            testPopulation.evolve();
            if (testPopulation.getFittestChromosome().getFitnessValue() <= maxFitnessValue) continue;
            maxFitnessValue = testPopulation.getFittestChromosome().getFitnessValue();
            testPopulation.getFittestChromosome().clone();
        }
        maxDistance = testPopulation.getFittestChromosome().getFitnessValue();
        MinDistanceFitness.setNotTest();
        int testValue = (int)((double)maxDistance * 0.9);
        MinDistanceFitness.setTestValue(testValue);
    }
}

