/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.graph;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.SugiyamaLayoutAlgorithm;

public class MraldLayoutAlgorithm
extends SugiyamaLayoutAlgorithm {
    public void run(JGraph jgraph, Object[] cells, int step) {
        Vector roots;
        CellView[] selectedCellViews = jgraph.getGraphLayoutCache().getMapping(cells);
        Rectangle2D.Double maxBounds = new Rectangle2D.Double();
        for (int i = 0; i < selectedCellViews.length; ++i) {
            Rectangle2D bounds;
            if (!(selectedCellViews[i] instanceof VertexView) || (bounds = selectedCellViews[i].getBounds()) == null) continue;
            maxBounds.setFrame(0.0, 0.0, Math.max(bounds.getWidth(), ((RectangularShape)maxBounds).getWidth()), Math.max(bounds.getHeight(), ((RectangularShape)maxBounds).getHeight()));
        }
        if (this.spacing.x == 0) {
            this.spacing.x = (int)(2.0 * ((RectangularShape)maxBounds).getWidth());
        }
        if (this.spacing.y == 0) {
            this.spacing.y = (int)(2.0 * ((RectangularShape)maxBounds).getHeight());
        }
        if ((roots = this.searchRoots(jgraph, selectedCellViews)).size() == 0) {
            return;
        }
        Vector levels = this.fillLevels(jgraph, selectedCellViews, roots);
        this.solveEdgeCrosses(jgraph, levels);
        this.moveToBarycenter(jgraph, selectedCellViews, levels);
        Point min = this.findMinimumAndSpacing(selectedCellViews, this.spacing);
        this.drawGraph(jgraph, levels, min, this.spacing);
        this.cleanUp(jgraph, selectedCellViews);
    }

    protected void cleanUp(JGraph jgraph, CellView[] cells) {
        jgraph.getGraphLayoutCache().remove(jgraph.getRoots());
        jgraph.getGraphLayoutCache().refresh(cells, true);
    }
}

