/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.lattice;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.jgap.Gene;
import org.jgap.impl.IntegerGene;
import org.mitre.lattice.lattice.InvalidLatticeStructureException;
import org.mitre.lattice.lattice.LatticeFunctions;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.lattice.LatticeTree;
import org.mitre.lattice.lattice.NodeNotFoundException;
import org.mitre.lattice.lattice.NullLatticeNodeException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatticeFunctionsImpl {
    public static final String KEY = LatticeFunctionsImpl.class.getName();
    public static final Logger log = Logger.getLogger(KEY);
    public static int NO_OF_NODES = 0;
    public static String ROOT_LABEL = "Public";
    public static int screenWidth = 900;
    private static boolean isSet = false;
    private static HashMap<Integer, LatticeNode> mapGeneToNode = new HashMap();
    private static HashMap<Integer, Integer> mapLevelCount = new HashMap();
    private static HashMap<LatticeNode, Integer> mapNodeToGene = new HashMap();
    private static HashMap<LatticeNode, Integer> maplevelOfNode = new HashMap();
    private static int maxLevel = 0;
    private static int maxNodePerLevel = 0;
    private static LatticeNode rootNode = null;
    public static int screenHeight = 700;

    public boolean getIsSet() {
        return isSet;
    }

    public void setIsSet(boolean nowSet) {
        isSet = nowSet;
        if (!isSet) {
            this.reset();
        }
    }

    public int getAllLinks() {
        int noOfLinks = 0;
        int n1 = 0;
        int n2 = 0;
        for (int i = 1; i < mapLevelCount.size(); ++i) {
            n1 = mapLevelCount.get(new Integer(i));
            n2 = mapLevelCount.get(new Integer(i - 1));
            noOfLinks += n1 * n2;
        }
        return noOfLinks;
    }

    public int getAvgDistance() {
        double avgDist = Math.sqrt(this.getBoxWidth() * this.getBoxWidth() / 4 + this.getBoxHeight() * this.getBoxHeight());
        return (int)avgDist;
    }

    public int getBoxHeight(int screenHeight) {
        return screenHeight / maxLevel;
    }

    public int getBoxHeight() {
        return screenHeight / maxLevel;
    }

    public int getBoxWidth(int screenWidth) {
        if (maxNodePerLevel != 0) {
            return screenWidth / maxNodePerLevel;
        }
        return 1;
    }

    public int getBoxWidth() {
        if (maxNodePerLevel != 0) {
            return screenWidth / maxNodePerLevel;
        }
        return 1;
    }

    public double getDistanceBetweenNodes(double x1, double x2, double y1, double y2) {
        double xd = x2 - x1;
        double yd = y2 - y1;
        return Math.sqrt(xd * xd + yd * yd);
    }

    public double getDistanceBetweenNodes(int x1, int x2, int yd) {
        double xd = x2 - x1;
        return Math.sqrt(xd * xd + (double)(yd * yd));
    }

    public ArrayList getFlatLattice(LatticeNode root) {
        if (isSet) {
            return this.getFlatLattice();
        }
        this.setIsSet(true);
        ArrayList<LatticeNode> flattenLattice = new ArrayList<LatticeNode>();
        flattenLattice = this.addRoot(flattenLattice, root);
        flattenLattice = this.flattenLattice(flattenLattice, root, 0);
        return flattenLattice;
    }

    public ArrayList getFlatLattice() {
        ArrayList<LatticeNode> flatLattice = new ArrayList<LatticeNode>();
        Iterator<LatticeNode> iter = maplevelOfNode.keySet().iterator();
        while (iter.hasNext()) {
            flatLattice.add(iter.next());
        }
        return flatLattice;
    }

    public int getHeight() {
        return screenHeight;
    }

    public Integer getInteger(LatticeNode node) {
        return mapNodeToGene.get(node);
    }

    public int getLevelOfNode(LatticeNode node) {
        return maplevelOfNode.get(node);
    }

    public HashMap getMapGeneToNode() {
        return mapGeneToNode;
    }

    public HashMap getMapNodeToGene() {
        return mapNodeToGene;
    }

    public int getMaxLevel() {
        return maxLevel;
    }

    public int getMaxNodesPerLevel() {
        return maxNodePerLevel;
    }

    public ArrayList getMostDominant(LatticeNode root) {
        this.initialize(root);
        return this.getNodesOnLevel(this.getMaxLevel() - 1);
    }

    public ArrayList getMostDominant(int levelDown) {
        return this.getNodesOnLevel(this.getMaxLevel() - 1 - levelDown);
    }

    public int getNoOfGrids() {
        return maxLevel * maxNodePerLevel;
    }

    public LatticeNode getNode(Integer nodeInteger) {
        return mapGeneToNode.get(nodeInteger);
    }

    public ArrayList<LatticeNode> getNodesOnLevel(int level) {
        Integer thisLevel = new Integer(level);
        ArrayList<LatticeNode> onThisLevel = new ArrayList<LatticeNode>();
        for (LatticeNode node : maplevelOfNode.keySet()) {
            if (!maplevelOfNode.get(node).equals(thisLevel)) continue;
            onThisLevel.add(node);
        }
        return onThisLevel;
    }

    public ArrayList getNodesOnSameLevel(LatticeNode thisNode) {
        Integer thisLevel = maplevelOfNode.get(thisNode);
        ArrayList<Integer> onThisLevel = new ArrayList<Integer>();
        for (LatticeNode node : maplevelOfNode.keySet()) {
            if (!maplevelOfNode.get(node).equals(thisLevel)) continue;
            onThisLevel.add(LatticeFunctions.getInteger(node));
        }
        return onThisLevel;
    }

    public ArrayList getParents(LatticeNode node) {
        return node.getParents();
    }

    public LatticeNode getRootNode() {
        return rootNode;
    }

    public void setRootNode(LatticeNode rootNode) {
        LatticeFunctionsImpl.rootNode = rootNode;
    }

    public int getWidth() {
        return screenWidth;
    }

    public int getY(Integer nodeInteger) {
        LatticeNode node = mapGeneToNode.get(nodeInteger);
        return (maxLevel - this.getLevelOfNode(node)) * this.getBoxHeight();
    }

    public ArrayList<LatticeNode> addRoot(ArrayList<LatticeNode> flatLattice, LatticeNode thisRootNode) {
        rootNode = thisRootNode;
        flatLattice.add(rootNode);
        int geneIndex = flatLattice.size() - 1;
        mapGeneToNode.put(new Integer(geneIndex), rootNode);
        mapNodeToGene.put(rootNode, new Integer(geneIndex));
        this.changeNodesPerLevel(rootNode, new Integer(0));
        return flatLattice;
    }

    public int calcMaxDistance() {
        return this.getAllLinks() * this.getAvgDistance();
    }

    public int calcMaxNodesPerLevel() {
        int max = 0;
        int levelNo2 = 0;
        for (int levelNo2 : mapLevelCount.values()) {
            if (levelNo2 <= max) continue;
            max = levelNo2;
        }
        maxNodePerLevel = max;
        return max;
    }

    public int changeNodesPerLevel(LatticeNode node, Integer newLevel) {
        if (!mapLevelCount.containsKey(newLevel)) {
            mapLevelCount.put(newLevel, new Integer(1));
            maplevelOfNode.put(node, newLevel);
            return newLevel;
        }
        if (maplevelOfNode.containsKey(node)) {
            Integer oldLevel = maplevelOfNode.get(node);
            if (oldLevel > newLevel) {
                return oldLevel;
            }
            int oldNoOfNodes = mapLevelCount.get(oldLevel);
            mapLevelCount.put(oldLevel, new Integer(--oldNoOfNodes));
        }
        maplevelOfNode.put(node, newLevel);
        int oldNoOfNodesInNewLevel = mapLevelCount.get(newLevel);
        mapLevelCount.put(newLevel, new Integer(++oldNoOfNodesInNewLevel));
        return newLevel;
    }

    public void checkMaxLevel(int currentLevel) {
        if (currentLevel > maxLevel) {
            maxLevel = currentLevel;
        }
    }

    public Object getSubTree(LatticeTree childTree, LatticeNode keyNode) throws NullLatticeNodeException, InvalidLatticeStructureException {
        LatticeNode childRoot = childTree.getRootNode();
        ArrayList labNodes = new ArrayList();
        labNodes = this.addLabNodes(rootNode, labNodes);
        log.info("No of Lab Nodes: " + labNodes.size());
        for (int i = 0; i < labNodes.size(); ++i) {
            LatticeNode currNode = Config.getLatticeFactory().copyNode((LatticeNode)labNodes.get(i));
            try {
                childTree.searchTree(currNode);
                continue;
            }
            catch (NodeNotFoundException e) {
                log.info("Adding currNode " + currNode.getName());
                childRoot.addParent(currNode);
                currNode.addChild(childRoot);
            }
        }
        return childRoot;
    }

    public Object getChildTree(LatticeNode keyNode) throws NullLatticeNodeException, InvalidLatticeStructureException {
        LatticeTree childTree = new LatticeTree();
        if (keyNode == null) {
            throw new NullLatticeNodeException("LATT-005");
        }
        rootNode = null;
        return this.copyAllChildren(keyNode, Config.getLatticeFactory().copyNode(keyNode), childTree);
    }

    public Object getChildTreeNoParents(LatticeNode keyNode) throws NullLatticeNodeException, InvalidLatticeStructureException {
        LatticeTree childTree = new LatticeTree();
        if (keyNode == null) {
            throw new NullLatticeNodeException("LATT-005");
        }
        rootNode = null;
        return this.copyOnlyChildren(keyNode, Config.getLatticeFactory().copyNode(keyNode), childTree);
    }

    public Object copyAllChildren(LatticeNode keyNode, LatticeNode copyNode, LatticeTree childTree) throws InvalidLatticeStructureException {
        try {
            if (keyNode.countChildNodes() == 0) {
                if (childTree.getRootNode() == null) {
                    childTree.setRootNode(copyNode);
                    return copyNode;
                }
                LatticeNode childRootNode = childTree.getRootNode();
                for (int i = 0; i < copyNode.getParents().size(); ++i) {
                    childRootNode.addParent(copyNode.getParents().get(i));
                }
                childTree.setRootNode(copyNode);
                return copyNode;
            }
            Object endNode = null;
            ArrayList<LatticeNode> children = keyNode.getChildren();
            for (int i = 0; i < keyNode.countChildNodes(); ++i) {
                LatticeNode node = children.get(i);
                LatticeNode childNode = null;
                try {
                    childNode = childTree.searchTree(node.getName());
                }
                catch (NodeNotFoundException e) {
                    childNode = Config.getLatticeFactory().copyNode(node);
                }
                copyNode.addChild(childNode);
                LatticeNode childParent = null;
                ArrayList<LatticeNode> keyParents = keyNode.getParents();
                for (int j = 0; j < keyParents.size(); ++j) {
                    String keyParentName = keyParents.get(j).getName();
                    try {
                        childParent = childTree.searchTree(keyParentName);
                    }
                    catch (NodeNotFoundException e) {
                        childParent = Config.getLatticeFactory().createNode(keyParents.get(j));
                    }
                    copyNode.addParent(childParent);
                    childParent.addChild(copyNode);
                }
                childNode.addParent(copyNode);
                endNode = this.copyAllChildren(node, childNode, childTree);
            }
            return endNode;
        }
        catch (InvalidLatticeStructureException e) {
            throw new InvalidLatticeStructureException(e.getMessage(), e.getDetail());
        }
    }

    public Object copyOnlyChildren(LatticeNode keyNode, LatticeNode copyNode, LatticeTree childTree) throws InvalidLatticeStructureException {
        try {
            if (keyNode.countChildNodes() == 0) {
                if (childTree.getRootNode() == null) {
                    childTree.setRootNode(copyNode);
                    return copyNode;
                }
                LatticeNode childRootNode = childTree.getRootNode();
                for (int i = 0; i < copyNode.getParents().size(); ++i) {
                    childRootNode.addParent(copyNode.getParents().get(i));
                }
                childTree.setRootNode(copyNode);
                return copyNode;
            }
            Object endNode = null;
            ArrayList<LatticeNode> children = keyNode.getChildren();
            for (int i = 0; i < keyNode.countChildNodes(); ++i) {
                LatticeNode node = children.get(i);
                LatticeNode childNode = null;
                try {
                    childNode = childTree.searchTree(node.getName());
                }
                catch (NodeNotFoundException e) {
                    childNode = Config.getLatticeFactory().copyNode(node);
                }
                copyNode.addChild(childNode);
                endNode = this.copyOnlyChildren(node, childNode, childTree);
            }
            return endNode;
        }
        catch (InvalidLatticeStructureException e) {
            throw new InvalidLatticeStructureException(e.getMessage(), e.getDetail());
        }
    }

    public ArrayList<LatticeNode> flattenLattice(ArrayList<LatticeNode> flatLattice, LatticeNode rootNode, int level) {
        int i;
        if (rootNode == null) {
            System.out.print("In LF: flattenLattice(). Root node is null : ");
            return flatLattice;
        }
        ArrayList<LatticeNode> parents = rootNode.getParents();
        int geneIndex = flatLattice.size() - 1;
        this.checkMaxLevel(++level);
        for (i = 0; i < rootNode.countParentNodes(); ++i) {
            if (!flatLattice.contains(parents.get(i))) {
                flatLattice.add(parents.get(i));
                geneIndex = flatLattice.size() - 1;
                mapGeneToNode.put(new Integer(geneIndex), parents.get(i));
                mapNodeToGene.put(parents.get(i), new Integer(geneIndex));
            }
            this.changeNodesPerLevel(parents.get(i), new Integer(level));
        }
        for (i = 0; i < rootNode.countParentNodes(); ++i) {
            this.flattenLattice(flatLattice, parents.get(i), level);
        }
        if (level == 1) {
            NO_OF_NODES = flatLattice.size();
        }
        return flatLattice;
    }

    public int initialize(LatticeNode root) {
        if (isSet) {
            return 0;
        }
        ArrayList<LatticeNode> flattenLattice = new ArrayList<LatticeNode>();
        flattenLattice = this.addRoot(flattenLattice, root);
        flattenLattice = this.flattenLattice(flattenLattice, root, 0);
        this.calcMaxNodesPerLevel();
        this.getNoOfGrids();
        isSet = true;
        return flattenLattice.size();
    }

    public LatticeTree recoverLatticeTree(String filename) throws MraldException, FileNotFoundException, IOException {
        try {
            log.info("Getting old lattice file" + filename);
            FileInputStream isStream = new FileInputStream(filename);
            ObjectInputStream q = new ObjectInputStream(isStream);
            return (LatticeTree)q.readObject();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw new MraldException("Class LatticeTree was not found in the classpth.  Please have your administrator check the installation.", e);
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void reset() {
        mapGeneToNode = new HashMap();
        mapLevelCount = new HashMap();
        mapNodeToGene = new HashMap();
        maplevelOfNode = new HashMap();
        maxLevel = 0;
        maxNodePerLevel = 0;
    }

    public void serializeLatticeTree(LatticeTree tree, String filename) throws IOException {
        FileOutputStream ostream = new FileOutputStream(filename);
        ObjectOutputStream p = new ObjectOutputStream(ostream);
        p.writeObject(tree);
        p.flush();
        p.close();
    }

    public ArrayList<IntegerGene> snap(ArrayList<IntegerGene> genesOnThisLevel) {
        Collections.sort(genesOnThisLevel);
        int minGridPos = 0;
        int gridPos = 0;
        int boxWidth = this.getBoxWidth();
        for (int i = 0; i < genesOnThisLevel.size(); ++i) {
            IntegerGene thisGene = genesOnThisLevel.get(i);
            gridPos = thisGene.intValue() / boxWidth;
            if (gridPos <= minGridPos) {
                gridPos = minGridPos + 1;
            }
            minGridPos = gridPos;
            int newPos = gridPos * boxWidth - boxWidth / 2;
            thisGene.setAllele((Object)new Integer(newPos));
        }
        return genesOnThisLevel;
    }

    public Gene[] snapToGrid(Gene[] values) {
        for (int i = 0; i < mapLevelCount.size(); ++i) {
            ArrayList<LatticeNode> nodesOnThisLevel = this.getNodesOnLevel(i);
            ArrayList<IntegerGene> genesOnThisLevel = new ArrayList<IntegerGene>();
            HashMap<IntegerGene, LatticeNode> linkGenesToNodes = new HashMap<IntegerGene, LatticeNode>();
            for (int j = 0; j < nodesOnThisLevel.size(); ++j) {
                LatticeNode newNode = nodesOnThisLevel.get(j);
                IntegerGene thisGene = (IntegerGene)values[this.getInteger(newNode)];
                genesOnThisLevel.add(thisGene);
                linkGenesToNodes.put(thisGene, newNode);
            }
            this.snap(genesOnThisLevel);
        }
        return values;
    }

    public ArrayList<IntegerGene> spaceNodes(ArrayList<IntegerGene> genesOnThisLevel) {
        IntegerGene thisGene;
        Collections.sort(genesOnThisLevel);
        int MIN_SPACING = this.getBoxWidth() * 2 / 3;
        if (MIN_SPACING < 100) {
            MIN_SPACING = 100;
        }
        boolean ok = false;
        for (int iterations = 0; !ok && iterations < 10; ++iterations) {
            ok = true;
            StringBuffer ret = new StringBuffer();
            IntegerGene previousGene = genesOnThisLevel.get(0);
            ret.append(previousGene.intValue());
            for (int i = 1; i < genesOnThisLevel.size(); ++i) {
                thisGene = genesOnThisLevel.get(i);
                ret.append(thisGene.intValue());
                if (thisGene.intValue() - previousGene.intValue() < MIN_SPACING) {
                    ok = false;
                    int spacingDeficiet = MIN_SPACING - (thisGene.intValue() - previousGene.intValue());
                    thisGene.setAllele((Object)new Integer(thisGene.intValue() + spacingDeficiet / 2));
                    previousGene.setAllele((Object)new Integer(previousGene.intValue() - spacingDeficiet / 2));
                }
                previousGene = thisGene;
            }
        }
        IntegerGene leftGene = genesOnThisLevel.get(0);
        IntegerGene rightGene = genesOnThisLevel.get(genesOnThisLevel.size() - 1);
        int rowMidPoint = (leftGene.intValue() + rightGene.intValue()) / 2;
        int screenMidPoint = screenWidth / 2;
        int move = screenMidPoint - rowMidPoint;
        for (int i = 0; i < genesOnThisLevel.size(); ++i) {
            thisGene = genesOnThisLevel.get(i);
            thisGene.setAllele((Object)new Integer(thisGene.intValue() + move));
        }
        return genesOnThisLevel;
    }

    public Gene[] spaceOutLevels(Gene[] values) {
        for (int i = 0; i < mapLevelCount.size(); ++i) {
            ArrayList<LatticeNode> nodesOnThisLevel = this.getNodesOnLevel(i);
            ArrayList<IntegerGene> genesOnThisLevel = new ArrayList<IntegerGene>();
            for (int j = 0; j < nodesOnThisLevel.size(); ++j) {
                LatticeNode newNode = nodesOnThisLevel.get(j);
                IntegerGene thisGene = (IntegerGene)values[this.getInteger(newNode)];
                genesOnThisLevel.add(thisGene);
            }
            this.spaceNodes(genesOnThisLevel);
        }
        return values;
    }

    public List sort(ArrayList groupList) {
        Collections.sort(groupList);
        return groupList;
    }

    public LatticeTree wrapTree(LatticeTree tre) throws InvalidLatticeStructureException {
        return new LatticeTree(this.wrapNodes(Config.getLatticeFactory().createNode("Public"), tre.getRootNode()));
    }

    public LatticeNode wrapNodes(LatticeNode wrappedChildNode, LatticeNode node) throws InvalidLatticeStructureException {
        LatticeNode newNode = Config.getLatticeFactory().createNodeWithoutChildren(node);
        for (int i = 0; i < node.countParentNodes(); ++i) {
            ArrayList<LatticeNode> parents = node.getParents();
            LatticeNode wrappedNode = this.wrapNodes(newNode, parents.get(i));
            wrappedNode.addChild(wrappedChildNode);
        }
        return newNode;
    }

    public int getScreenWidth() {
        return screenWidth;
    }

    private ArrayList addLabNodes(LatticeNode rootNode, ArrayList labNodes) throws NullLatticeNodeException, InvalidLatticeStructureException {
        return labNodes;
    }
}

