/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.lattice;

import java.io.Serializable;
import java.util.ArrayList;
import org.mitre.lattice.lattice.InvalidLatticeStructureException;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.lattice.LatticeTreeInterface;
import org.mitre.lattice.lattice.NodeNotFoundException;
import org.mitre.mrald.util.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatticeTree
implements LatticeTreeInterface,
Serializable {
    private LatticeNode root_node = null;
    public static String ROOT_LABEL = "Public";

    public LatticeTree() {
        this.root_node = Config.getLatticeFactory().createNode(ROOT_LABEL);
    }

    public LatticeTree(String root_name) {
        this.root_node = Config.getLatticeFactory().createNode(root_name);
    }

    public LatticeTree(LatticeNode root_node) {
        this.root_node = root_node;
    }

    public LatticeTree(LatticeTree newTree) {
        this.root_node = newTree.getRootNode();
    }

    @Override
    public LatticeNode getRootNode() {
        return this.root_node;
    }

    public void setRootNode(LatticeNode thisNode) {
        this.root_node = thisNode;
    }

    public LatticeNode[] getRootNodeArray() {
        LatticeNode[] ret = new LatticeNode[]{this.root_node};
        return ret;
    }

    public ArrayList<LatticeNode> getRootNodeArrayList() {
        ArrayList<LatticeNode> ret = new ArrayList<LatticeNode>();
        ret.add(this.root_node);
        return ret;
    }

    @Override
    public boolean addNode(String name, ArrayList<LatticeNode> nodeParents, ArrayList<LatticeNode> nodeChildren) throws InvalidLatticeStructureException {
        nodeChildren.add(this.root_node);
        LatticeNode temp = Config.getLatticeFactory().createNode(name, nodeChildren, nodeParents);
        this.root_node.addParent(temp);
        return true;
    }

    public boolean addNode(LatticeNode newNode) throws InvalidLatticeStructureException {
        ArrayList<LatticeNode> children = new ArrayList<LatticeNode>();
        children.add(this.root_node);
        newNode.addChildren(children);
        this.root_node.addParent(newNode);
        return this.root_node.countParentNodes() > 0;
    }

    public boolean addNode(String name) throws InvalidLatticeStructureException {
        LatticeNode newNode = Config.getLatticeFactory().createNode(name);
        newNode.addChild(this.root_node);
        if (!this.root_node.addParent(newNode)) {
            return false;
        }
        return this.root_node.countParentNodes() > 0;
    }

    @Override
    public boolean checkTree() {
        return this.root_node.getChildren() == null;
    }

    public int countNodes() {
        return this.root_node.getParents().size();
    }

    public void removeCyclic(LatticeNode childNode, LatticeNode newNode) throws InvalidLatticeStructureException {
        ArrayList dominatesNewNode = this.dominates(newNode);
        ArrayList<LatticeNode> childParents = childNode.getParents();
        for (int i = childParents.size(); i > 0; --i) {
            LatticeNode childParent = childParents.get(i - 1);
            if (!dominatesNewNode.contains(childParent)) continue;
            childNode.removeParent(childParent);
            childParent.removeChild(childNode);
        }
    }

    public void removeCyclicChild(LatticeNode parentNode, LatticeNode newNode) throws InvalidLatticeStructureException {
        ArrayList<LatticeNode> childOfNewNode = this.children(newNode);
        ArrayList<LatticeNode> parentChildren = parentNode.getChildren();
        for (int i = parentChildren.size(); i > 0; --i) {
            LatticeNode parentChild = parentChildren.get(i - 1);
            if (!childOfNewNode.contains(parentChild)) continue;
            parentNode.removeChild(parentChild);
            parentChild.removeParent(parentNode);
        }
    }

    @Override
    public ArrayList dominates(LatticeNode keyNode) {
        ArrayList<LatticeNode> dominatesList = new ArrayList<LatticeNode>();
        if (keyNode == this.root_node) {
            dominatesList.add(keyNode);
        }
        dominatesList = this.getDominatesList(keyNode, dominatesList, true);
        return dominatesList;
    }

    public boolean isChild(LatticeNode currentNode, LatticeNode addNode) {
        ArrayList<LatticeNode> childList = this.children(currentNode);
        return childList.contains(addNode);
    }

    public boolean isDirectChild(LatticeNode currentNode, LatticeNode keyNode) {
        return keyNode.getChildren().contains(currentNode);
    }

    public boolean isDirectParent(LatticeNode currentNode, LatticeNode addNode) {
        return false;
    }

    public ArrayList<LatticeNode> children(LatticeNode keyNode) {
        ArrayList<LatticeNode> childList = new ArrayList<LatticeNode>();
        return this.getChildrenList(keyNode, childList, true);
    }

    private ArrayList<LatticeNode> getDominatesList(LatticeNode keyNode, ArrayList<LatticeNode> oldList, boolean downLevel) {
        try {
            ArrayList<LatticeNode> parentList = oldList;
            ArrayList<LatticeNode> parents = keyNode.getParents();
            for (int i = 0; i < parents.size(); ++i) {
                LatticeNode newNode = parents.get(i);
                if (!parentList.contains(newNode)) {
                    parentList.add(newNode);
                }
                if (newNode.getParents().size() <= 0 || !downLevel) continue;
                parentList = this.getDominatesList(newNode, parentList, downLevel);
            }
            return parentList;
        }
        catch (Exception e) {
            return null;
        }
    }

    private ArrayList<LatticeNode> getChildrenList(LatticeNode keyNode, ArrayList<LatticeNode> oldList, boolean downLevel) {
        ArrayList<LatticeNode> childList = oldList;
        ArrayList<LatticeNode> children = keyNode.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            LatticeNode newNode = children.get(i);
            if (!childList.contains(newNode)) {
                childList.add(newNode);
            }
            if (newNode.getParents().size() <= 0 || !downLevel) continue;
            this.getChildrenList(newNode, childList, downLevel);
        }
        return childList;
    }

    @Override
    public boolean equals(LatticeTree testTree) {
        return false;
    }

    @Override
    public LatticeTree exportTree() {
        return new LatticeTree();
    }

    @Override
    public int hash(LatticeTree testTree) {
        return 0;
    }

    @Override
    public boolean importTree(LatticeTree keyTree) {
        return false;
    }

    @Override
    public boolean removeNode(String name) {
        return false;
    }

    @Override
    public LatticeNode[] searchTree(LatticeNode keyNode) throws NodeNotFoundException {
        ArrayList parents;
        if (this.root_node == null) {
            // empty if block
        }
        if ((parents = this.dominates(this.root_node)).contains(keyNode)) {
            return new LatticeNode[]{keyNode};
        }
        if (keyNode.equals(this.root_node)) {
            return new LatticeNode[]{this.root_node};
        }
        NodeNotFoundException notFound = new NodeNotFoundException("No node of name " + keyNode.getName() + " found");
        throw notFound;
    }

    public LatticeNode searchTree(String nodeName) throws NodeNotFoundException {
        if (this.root_node == null) {
            // empty if block
        }
        ArrayList parents = this.dominates(this.root_node);
        String thisNodeName = null;
        for (int i = 0; i < parents.size(); ++i) {
            thisNodeName = ((LatticeNode)parents.get(i)).getName();
            if (!nodeName.equals(thisNodeName)) continue;
            return (LatticeNode)parents.get(i);
        }
        NodeNotFoundException notFound = new NodeNotFoundException("LATT-004", "\nDetails : Group " + nodeName + " not found. ");
        throw notFound;
    }
}

