/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.query;

import java.util.ArrayList;
import java.util.List;
import org.mitre.lattice.graph.GraphUserLattice;
import org.mitre.lattice.lattice.InsufficentGroupAccessException;
import org.mitre.lattice.lattice.InvalidLatticeStructureException;
import org.mitre.lattice.lattice.LatticeErrorHandler;
import org.mitre.lattice.lattice.LatticeFunctions;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.lattice.LatticeTree;
import org.mitre.lattice.lattice.NodeNotFoundException;
import org.mitre.lattice.lattice.NullLatticeNodeException;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.MraldException;

public class GroupList
extends AbstractStep {
    public List getGroups(String keyGroup) throws NodeNotFoundException, InsufficentGroupAccessException, MraldException {
        ArrayList allGroups = new ArrayList();
        allGroups = !keyGroup.equals("") ? (ArrayList)this.getAllGroups(keyGroup) : (ArrayList)this.getAllGroups();
        return allGroups;
    }

    public List getAllGroups() throws InsufficentGroupAccessException, NodeNotFoundException, NullLatticeNodeException, InvalidLatticeStructureException, MraldException {
        LatticeFunctions.setImplmnt();
        LatticeFunctions.setIsSet(false);
        ArrayList allGroups = new ArrayList();
        LatticeTree newLattice = (LatticeTree)GraphUserLattice.getLattice();
        allGroups = LatticeFunctions.getFlatLattice(newLattice.getRootNode());
        LatticeFunctions.sort(allGroups);
        return allGroups;
    }

    public List getAllGroups(String keyGroup) throws InsufficentGroupAccessException, NodeNotFoundException, NullLatticeNodeException, InvalidLatticeStructureException, MraldException {
        LatticeFunctions.setImplmnt();
        ArrayList allGroups = new ArrayList();
        LatticeTree newLattice = (LatticeTree)GraphUserLattice.getLattice();
        LatticeNode key = null;
        try {
            key = newLattice.searchTree(keyGroup);
        }
        catch (NodeNotFoundException e) {
            key = newLattice.getRootNode();
        }
        if (key != newLattice.getRootNode()) {
            LatticeTree childTree = new LatticeTree((LatticeNode)LatticeFunctions.getChildTree(key));
            LatticeFunctions.setIsSet(false);
            if (childTree == null || childTree.getRootNode() == null) {
                InsufficentGroupAccessException latticeErr = null;
                latticeErr = new InsufficentGroupAccessException("LATT-003");
                LatticeErrorHandler.handleException(null, latticeErr, true);
            }
            allGroups = LatticeFunctions.getFlatLattice(childTree.getRootNode());
            List allGroupsSorted = LatticeFunctions.sort(allGroups);
            return allGroupsSorted;
        }
        allGroups = LatticeFunctions.getFlatLattice(newLattice.getRootNode());
        return allGroups;
    }

    public List getChildren(String keyGroup) throws MraldException {
        try {
            return this.getChildGroups(keyGroup);
        }
        catch (InsufficentGroupAccessException e) {
            throw new MraldException(e.getMessage());
        }
        catch (NodeNotFoundException e) {
            throw new MraldException(e.getMessage());
        }
        catch (NullLatticeNodeException e) {
            throw new MraldException(e.getMessage());
        }
        catch (InvalidLatticeStructureException e) {
            throw new MraldException(e.getMessage());
        }
    }

    public List getChildGroups(String keyGroup) throws InsufficentGroupAccessException, NodeNotFoundException, NullLatticeNodeException, InvalidLatticeStructureException, MraldException {
        LatticeFunctions.setImplmnt();
        LatticeNode key = null;
        ArrayList<LatticeNode> allGroups = new ArrayList<LatticeNode>();
        LatticeTree newLattice = (LatticeTree)GraphUserLattice.getLattice();
        try {
            key = newLattice.searchTree(keyGroup);
        }
        catch (NodeNotFoundException e) {
            key = newLattice.getRootNode();
        }
        allGroups.add(key);
        if (key != newLattice.getRootNode()) {
            allGroups.addAll(newLattice.children(key));
        }
        return allGroups;
    }

    public void execute(MsgObject msg) throws WorkflowStepException {
    }
}

