/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.query;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.query.GroupList;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.output.HTMLOutput;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;

public class LabellerOutput
extends HTMLOutput {
    private String labelTable = null;
    private String labelColumn = null;
    private String groupName = null;

    public void execute(MsgObject msg) throws WorkflowStepException {
        String labelParams = msg.getValue("ParamsLabel")[0];
        this.parseLabelParams(labelParams);
        User user = (User)msg.getReq().getSession().getAttribute(Config.getProperty("cookietag"));
        if (user == null) {
            throw new WorkflowStepException("You must login to perform this operation");
        }
        if (user.getGroup() == null) {
            throw new WorkflowStepException("You must login to perform this operation");
        }
        this.groupName = user.getGroup();
        String[] queries = msg.getQuery();
        String link = " AND ";
        for (int i = 0; i < queries.length; ++i) {
            link = queries[i].toUpperCase().indexOf("WHERE") > 0 ? " AND " : " WHERE ";
            queries[i] = queries[i] + link + " owner = '" + user.getEmail() + "'";
        }
        super.execute(msg);
    }

    public void printNavigation(PrintWriter out) {
        out.println("<center><table cellpadding='0' cellspacing='0' border='0' width='600'>\n");
        out.println("<tr><td>\n");
        out.print("<script language='JavaScript1.2' type='text/javascript' src='");
        out.print(Config.getProperty("BaseUrl"));
        out.println("/navi.js'>");
        out.print("</script>\n");
        out.print(this.getJavaScript());
        out.println("</td></tr>\n");
        out.println("</table></center>\n");
    }

    public void printHtmlResults(PrintWriter out) throws ServletException, IOException, SQLException {
        float fileSize;
        int p;
        out.println("<tr>");
        out.println("<form enctype='x-www-form-urlencoded' action='FormSubmit' method='POST' name=\"o\">");
        out.println("<input name='Schema' type='hidden' value='public'><input name='form' type='hidden' value='Labelling'><input value='Set Label' name='workflow' type='hidden'>");
        StringBuffer headerRow = new StringBuffer("<tr>");
        for (p = 0; p < this.niceNames.length; ++p) {
            headerRow.append("<th>" + this.niceNames[p] + "</th>");
        }
        headerRow.append("<th>Set Label</th></tr>");
        out.println(headerRow.toString());
        headerRow = new StringBuffer("<tr>");
        for (p = 0; p < this.niceNames.length; ++p) {
            headerRow.append("<th></th>");
        }
        headerRow.append(" <th>All<input type='checkbox' onclick=\"if(this.checked==false){ClearAll('Label');}\n else{CheckAll('Label');}\">");
        headerRow.append("</th></tr>");
        out.println(headerRow.toString());
        int row_count = 0;
        for (fileSize = 0.0f; this.rs.next() && (this.lineLimitSize == -1 || row_count < this.lineLimitSize) && (this.mbLimitSize == -1.0f || fileSize < this.mbLimitSize); fileSize += 10.0f) {
            out.print("<tr>");
            for (int i = 0; i < this.niceNames.length; ++i) {
                String formattedString = this.classNames[i].equals("Timestamp") ? this.getAndFormat(this.rs.getTimestamp(i + 1), this.formats[i]) : (this.classNames[i].equals("BigDecimal") ? this.getAndFormat(this.rs.getBigDecimal(i + 1), this.formats[i]) : this.rs.getString(i + 1));
                out.print("<td>" + formattedString + "</td>");
                try {
                    fileSize += (float)(formattedString.length() + 9);
                    continue;
                }
                catch (NullPointerException npe) {
                    fileSize += 13.0f;
                }
            }
            String labelInfo = "<td><input type=\"checkbox\" checked name=\"Label" + row_count + "\" value=\"Table:" + this.labelTable + "~Column:" + this.labelColumn + "~Value:" + this.rs.getString(this.labelColumn) + "~CurrentCOI:" + this.rs.getString("label") + "\"></td>";
            out.println(labelInfo);
            out.println("</tr>");
            if ((double)(++row_count) / 1000.0 != (double)((int)((double)row_count / 1000.0))) continue;
            out.println("</table><table border='1' cellpadding='3'>" + headerRow.toString());
        }
        out = this.getGroupList(out);
        this.recordsReturned = row_count;
        this.bytesReturned = fileSize;
        out.println("<br><br><input value='Set Label' type='submit'><br><br><input value='Reset Form' type='reset'>");
    }

    private PrintWriter getGroupList(PrintWriter out) throws ServletException, IOException, SQLException {
        try {
            GroupList grpList = new GroupList();
            ArrayList groups = (ArrayList)grpList.getChildren(this.groupName);
            out.println("</table><br>Select Label<br><SELECT name='COI'>");
            for (int i = 0; i < groups.size(); ++i) {
                String latticeGroup = ((LatticeNode)groups.get(i)).getName();
                out.println("<OPTION value=\"" + MiscUtils.checkApostrophe(latticeGroup) + "\">" + latticeGroup + "</OPTION>");
            }
            out.println("</SELECT>");
            return out;
        }
        catch (MraldException mraldException) {
            return null;
        }
    }

    private void parseLabelParams(String labelParams) {
        StringTokenizer labelTokens = new StringTokenizer(labelParams, "~");
        while (labelTokens.hasMoreTokens()) {
            String nvp = labelTokens.nextToken();
            int splitPoint = nvp.indexOf(":");
            if (splitPoint == -1) continue;
            String label = nvp.substring(0, splitPoint);
            if (label.equals("Table")) {
                this.labelTable = nvp.substring(splitPoint + 1);
                continue;
            }
            this.labelColumn = nvp.substring(splitPoint + 1);
        }
    }

    private String getJavaScript() {
        String js = "<script type=\"text/javascript\">\n function CheckAll(val) {  \n var ml = document.forms.o;\n var len = ml.elements.length;\n for (var i = 0; i < len; i++){ \n  var e = ml.elements[i]; \n e.checked = true; \n if (e.name.indexOf(val)> 0) { e.checked = true;} \n } \n } \n function ClearAll(val) { \n var ml = document.forms.o; \n var len = ml.elements.length;\n for (var i = 0; i < len; i++){ \n var e = ml.elements[i];\n e.checked = false; if (e.name.indexOf(val) > 0) { e.checked = false;} \n } \n } \n </script>";
        return js;
    }
}

