/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.query;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.query.GroupList;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;

public class LatticeQuery
extends AbstractStep {
    public final void execute(MsgObject msg) throws WorkflowStepException {
        if (!Config.useLattice()) {
            return;
        }
        try {
            User user = LatticeQuery.getUser(msg);
            String[] queryOrig = msg.getQuery();
            for (int i = 0; i < queryOrig.length; ++i) {
                String query = LatticeQuery.adaptQuery(queryOrig[i], user);
                msg.setQuery(query, i);
            }
        }
        catch (MraldException e) {
            throw new WorkflowStepException(e, msg);
        }
    }

    public static String adaptQuery(String queryOrig, User user) throws MraldException {
        try {
            String keyGroup = user.getGroup();
            return LatticeQuery.adaptQuery(queryOrig, keyGroup);
        }
        catch (MraldException e) {
            throw new RuntimeException(e);
        }
    }

    public static String adaptQuery(String queryOrig, String keyGroup) throws MraldException {
        GroupList groupList = new GroupList();
        ArrayList groups = (ArrayList)groupList.getChildGroups(keyGroup);
        String WhereOrAnd = " AND ";
        String query = "";
        String queryOrigLow = queryOrig.toLowerCase();
        if (queryOrigLow.indexOf("where") < 1) {
            WhereOrAnd = " WHERE ";
        }
        String groupListStr = LatticeQuery.getGroupList(groups);
        ArrayList tableNames = LatticeQuery.parseTables(queryOrigLow);
        HashMap latticeSql = LatticeQuery.getLatticeSql(groupListStr);
        StringBuffer temp = LatticeQuery.buildSql(tableNames, latticeSql);
        String tableList = LatticeQuery.buildTableList(tableNames, latticeSql);
        int fromPos = -1;
        if (temp.length() > 0) {
            if (queryOrigLow.indexOf("from") > 0) {
                fromPos = queryOrig.toLowerCase().indexOf("from") + 4;
                query = queryOrig.substring(0, fromPos) + " " + tableList + queryOrig.substring(fromPos);
            }
            String queryLow = query.toLowerCase();
            int orderPos = query.length();
            int groupPos = query.length();
            int insertPos = 0;
            if (queryLow.indexOf("order by") > 0) {
                orderPos = queryLow.indexOf("order by");
            }
            if (queryLow.indexOf("group by") > 0) {
                groupPos = queryLow.indexOf("group by");
            }
            insertPos = Math.min(orderPos, groupPos);
            String ending = query.substring(insertPos);
            query = query.substring(0, insertPos) + WhereOrAnd + new String(temp) + ending;
        } else {
            query = queryOrig;
        }
        return query;
    }

    public static ArrayList parseTables(String sqlQuery) throws WorkflowStepException {
        ArrayList<String> tableNames = new ArrayList<String>();
        int whereIndex = sqlQuery.indexOf("where");
        int orderIndex = 0;
        int groupIndex = 0;
        if (whereIndex < 0) {
            whereIndex = sqlQuery.length();
            orderIndex = sqlQuery.indexOf("order by");
            if (orderIndex < 0) {
                orderIndex = sqlQuery.length();
            }
            if ((groupIndex = sqlQuery.indexOf("group by")) < 0) {
                groupIndex = sqlQuery.length();
            }
            whereIndex = Math.min(orderIndex, groupIndex);
        }
        String tables = sqlQuery.substring(sqlQuery.indexOf("from") + 4, whereIndex);
        StringTokenizer valueTokens = new StringTokenizer(tables, ",");
        while (valueTokens.hasMoreTokens()) {
            String nvp = valueTokens.nextToken();
            nvp = nvp.trim();
            tableNames.add(nvp);
        }
        return tableNames;
    }

    public static HashMap getLatticeSql(String groupList) throws WorkflowStepException {
        if (!Config.useLattice()) {
            return new HashMap();
        }
        try {
            HashMap<String, String> sqlTableList = new HashMap<String, String>();
            MraldConnection conn = new MraldConnection(MetaData.ADMIN_DB);
            String query = "select table_name, sql_clause from label_sql ";
            ResultSet r = conn.executeQuery(query);
            while (r.next()) {
                String tableName = r.getString("table_name").toLowerCase();
                String sql = r.getString("sql_clause");
                sqlTableList.put(tableName, sql + groupList);
            }
            r.close();
            conn.close();
            return sqlTableList;
        }
        catch (SQLException e) {
            throw new WorkflowStepException(e);
        }
    }

    public static StringBuffer buildSql(ArrayList tables, HashMap addSql) throws WorkflowStepException {
        StringBuffer newSql = new StringBuffer();
        Iterator iter = addSql.keySet().iterator();
        boolean isFirst = true;
        while (iter.hasNext()) {
            String tableName = (String)iter.next();
            if (!tables.contains(tableName)) continue;
            if (!isFirst) {
                newSql.append(" AND ");
            } else {
                isFirst = false;
            }
            newSql.append((String)addSql.get(tableName));
        }
        return newSql;
    }

    private static String buildTableList(ArrayList tables, HashMap latticeSql) throws WorkflowStepException {
        StringBuffer strBuf = new StringBuffer();
        for (String table : latticeSql.keySet()) {
            if (!tables.contains(table = table.toLowerCase()) || tables.contains(table + "_label")) continue;
            strBuf.append(table + "_label , ");
        }
        return strBuf.toString();
    }

    public static String getGroupList(ArrayList groups) throws WorkflowStepException {
        try {
            if (groups.size() == 0) {
                return " (Public) ";
            }
            StringBuffer groupList = new StringBuffer(" ( ");
            for (int i = 0; i < groups.size(); ++i) {
                groupList.append("'" + MiscUtils.checkApostrophe(((LatticeNode)groups.get(i)).getName()) + "'");
                if (i == groups.size() - 1) continue;
                groupList.append(", ");
            }
            groupList.append(" ) ");
            return new String(groupList);
        }
        catch (NullPointerException e) {
            WorkflowStepException we = new WorkflowStepException(e.getMessage());
            we.fillInStackTrace();
            throw we;
        }
    }

    public static User getUser(MsgObject msg) throws WorkflowStepException {
        try {
            HttpServletRequest req = msg.getReq();
            HttpSession ses = req.getSession();
            User user = null;
            HttpServletResponse resp = null;
            if (ses == null) {
                resp = msg.getRes();
                resp.sendRedirect(Config.getProperty("BaseUrl") + "/LatticeLogin.jsp?pageurl=" + req.getRequestURL());
                return null;
            }
            user = (User)ses.getAttribute(Config.getProperty("cookietag"));
            if (user == null) {
                resp.sendRedirect(Config.getProperty("BaseUrl") + "/LatticeLogin.jsp?pageurl=" + req.getRequestURL());
            }
            return user;
        }
        catch (NullPointerException e) {
            WorkflowStepException we = new WorkflowStepException(e.getMessage());
            we.fillInStackTrace();
            throw we;
        }
        catch (IOException e) {
            WorkflowStepException we = new WorkflowStepException(e.getMessage());
            we.fillInStackTrace();
            throw we;
        }
    }
}

