/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.taglib;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mitre.lattice.lattice.InsufficentGroupAccessException;
import org.mitre.lattice.lattice.InvalidLatticeStructureException;
import org.mitre.lattice.lattice.LatticeErrorHandler;
import org.mitre.lattice.lattice.LatticeFunctions;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.lattice.NodeNotFoundException;
import org.mitre.lattice.lattice.NullLatticeNodeException;
import org.mitre.lattice.query.GroupList;
import org.mitre.lattice.taglib.GroupModifyListTag;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.User;

public class GroupListTag
extends TagSupport {
    public static final String KEY = GroupListTag.class.getName();
    private String keyGroup = "Public";
    private String listOnly = "false";

    public GroupListTag() {
        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "GroupListTag : Start ");
    }

    public String getGroups(String keyGroup) throws NodeNotFoundException, InsufficentGroupAccessException, MraldException {
        this.keyGroup = keyGroup;
        GroupList groupList = new GroupList();
        StringBuffer buffer = new StringBuffer();
        ArrayList allGroups = new ArrayList();
        allGroups = (ArrayList)groupList.getGroups(keyGroup);
        List allGroupsSorted = LatticeFunctions.sort(allGroups);
        buffer.append(this.outputGroups((ArrayList)allGroupsSorted));
        return buffer.toString();
    }

    public String getGroups() throws InsufficentGroupAccessException, NodeNotFoundException, NullLatticeNodeException, InvalidLatticeStructureException, MraldException {
        GroupList groupList = new GroupList();
        StringBuffer buffer = new StringBuffer();
        ArrayList allGroups = new ArrayList();
        allGroups = (ArrayList)groupList.getGroups("");
        buffer.append(this.outputGroups(allGroups));
        return buffer.toString();
    }

    public String outputGroups(ArrayList allGroups) throws InsufficentGroupAccessException, NodeNotFoundException, NullLatticeNodeException, InvalidLatticeStructureException, MraldException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n<tr><th colspan=\"2\"></th></tr><td><b>Current COI:</b></td><td><b>" + this.keyGroup + "</b></td></tr>");
        buffer.append("\n<tr><th colspan=\"2\"></th></tr>");
        String groupName = null;
        for (int i = 0; i < allGroups.size(); ++i) {
            groupName = ((LatticeNode)allGroups.get(i)).getName().toString();
            buffer.append("\n<tr>");
            buffer.append("<td width=12 align='center' colspan=\"2\">" + groupName + "</td>");
            buffer.append("</tr>");
        }
        return buffer.toString();
    }

    public int doStartTag() throws JspException {
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        try {
            String modify = req.getParameter("ModifyNode");
            String groupList = null;
            if (this.listOnly.equals("true")) {
                String coi = "Public";
                Connection conn = new MraldConnection(MetaData.ADMIN_DB).getConnection();
                Statement stmt = conn.createStatement();
                User user = (User)this.pageContext.getSession().getAttribute(Config.getProperty("cookietag"));
                String email = user.getEmail();
                ResultSet rs = stmt.executeQuery("Select latticegroupid from people where email = '" + email + "'");
                if (rs.next()) {
                    coi = rs.getString(1);
                }
                rs.close();
                stmt.close();
                conn.close();
                this.pageContext.getOut().print(this.selectGroups(coi));
                return 0;
            }
            if (modify == null) {
                groupList = this.process(req);
            } else if (modify.equals("Focus") || modify.equals("Unfocus")) {
                groupList = this.process(req);
            } else {
                GroupModifyListTag groupListTag = Config.getLatticeFactory().getGroupModifyListTag();
                groupList = groupListTag.process((HttpServletRequest)this.pageContext.getRequest());
            }
            this.pageContext.getOut().print(groupList);
        }
        catch (NullPointerException e) {
            HttpServletResponse resp = (HttpServletResponse)this.pageContext.getResponse();
            try {
                resp.sendRedirect(Config.getProperty("BaseUrl") + "/LatticeLogin.jsp?pageurl=" + req.getRequestURL());
            }
            catch (IOException ie) {
                JspException se = new JspException((Throwable)ie);
                throw se;
            }
        }
        catch (IOException ie) {
            JspException se = new JspException((Throwable)ie);
            throw se;
        }
        catch (JspException e) {
            JspException se = new JspException((Throwable)e);
            throw se;
        }
        catch (MraldException e) {
            JspException se = new JspException((Throwable)e);
            throw se;
        }
        catch (SQLException e) {
            JspException se = new JspException((Throwable)e);
            throw se;
        }
        return 0;
    }

    private String selectGroups(String groupName) throws MraldException {
        StringBuffer rtnBuf = new StringBuffer();
        GroupList grpList = new GroupList();
        ArrayList groups = (ArrayList)grpList.getChildren(groupName);
        rtnBuf.append("<br><b>Select COI    </b><SELECT name='COI'>");
        for (int i = 0; i < groups.size(); ++i) {
            String latticeGroup = ((LatticeNode)groups.get(i)).getName();
            rtnBuf.append("<OPTION value=\"" + MiscUtils.checkApostrophe(latticeGroup) + "\">" + latticeGroup + "</OPTION>");
        }
        rtnBuf.append("</SELECT>");
        return rtnBuf.toString();
    }

    public String process(HttpServletRequest req) throws JspException {
        try {
            this.init();
            StringBuffer groupList = new StringBuffer();
            User user = (User)req.getSession().getAttribute(Config.getProperty("cookietag"));
            String keyGroup = null;
            keyGroup = user.getGroup();
            boolean showWholeLattice = false;
            String modifyLattice = req.getParameter("ModifyNode");
            if (modifyLattice == null) {
                showWholeLattice = false;
            } else if (modifyLattice.equals("Unfocus")) {
                showWholeLattice = true;
                groupList.append("<input type=\"hidden\" name=\"showLattice\" value=\"1\">\n");
            }
            if (showWholeLattice) {
                groupList.append(this.getGroups());
            } else if (keyGroup != null) {
                groupList.append(this.getGroups(keyGroup));
            }
            return groupList.toString();
        }
        catch (NodeNotFoundException e) {
            NodeNotFoundException latticeErr = null;
            latticeErr = e;
            LatticeErrorHandler.handleException(null, latticeErr, true);
        }
        catch (InsufficentGroupAccessException e) {
            InsufficentGroupAccessException latticeErr = null;
            latticeErr = e;
            LatticeErrorHandler.handleException(null, latticeErr, true);
        }
        catch (MraldException e) {
            JspException se = new JspException((Throwable)e);
            throw se;
        }
        return null;
    }

    public void setListOnly(String listOnly) {
        this.listOnly = listOnly;
    }

    public void setKeyGroup(String keyGroup) {
        this.keyGroup = keyGroup;
    }

    public void init() {
    }
}

