/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.taglib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mitre.lattice.graph.GraphUserLattice;
import org.mitre.lattice.lattice.InsufficentGroupAccessException;
import org.mitre.lattice.lattice.InvalidLatticeStructureException;
import org.mitre.lattice.lattice.LatticeFunctions;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.lattice.LatticeTree;
import org.mitre.lattice.lattice.NodeNotFoundException;
import org.mitre.lattice.lattice.NullLatticeNodeException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;

public class GroupModifyListTag
extends TagSupport {
    private String keyGroup = null;

    public String getAddGroups(String keyGroup) {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<input type=\"hidden\" NAME=\"Lattice\">\n");
            buffer.append("\n<tr><td colspan=\"1\">");
            buffer.append("<b>Specify Name</b></td>");
            buffer.append("\n<td colspan=\"2\"><input type='text' name=\"Lattice\"</td></tr>");
            String addLinks = this.getAddLinkGroups(keyGroup);
            return buffer.toString() + addLinks;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getDeleteLinks(String keyGroup) {
        try {
            StringBuffer buffer = new StringBuffer();
            ArrayList allGroups = (ArrayList)this.getAllGroups(keyGroup);
            buffer.append("<input type=\"hidden\" NAME=\"securityGroup\" value=\"" + keyGroup + "\">\n");
            buffer.append("\n<tr><td colspan=\"3\">");
            buffer.append("<b>Remove Link:</b></td></tr>\n");
            buffer.append("<tr><td colspan=\"1\"><b>Parent</b></td><td colspan=\"2\"><b>Child</b></td></tr>");
            int count = 0;
            for (int i = 0; i < allGroups.size(); ++i) {
                LatticeNode linkNode = (LatticeNode)allGroups.get(i);
                String linkParent = linkNode.getName();
                ArrayList<LatticeNode> children = linkNode.getChildren();
                for (int j = 0; j < children.size(); ++j) {
                    ++count;
                    buffer.append("\n<tr>");
                    buffer.append("<td align='center'>" + linkParent + "</td>");
                    buffer.append("<td width=7 align='center'> " + children.get(j).getName() + "</td>");
                    buffer.append("<td width=7 align='center'><input type='checkbox' name='Lattice" + count + "' value='Parent:" + linkParent + "~Child:" + children.get(j).getName() + "~Type:DeleteLink'></td>");
                    buffer.append("</tr>");
                }
            }
            return buffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAddLinkGroups(String keyGroup) throws MraldException {
        try {
            String groupName;
            int i;
            StringBuffer buffer = new StringBuffer();
            ArrayList allGroups = (ArrayList)this.getAllGroups(keyGroup);
            buffer.append("<tr><td colspan=\"1\"><b>Or Select Group:</b><td colspan=\"2\"><SELECT NAME=\"Lattice\">\n<OPTION></OPTION>\n");
            for (i = 0; i < allGroups.size(); ++i) {
                groupName = ((LatticeNode)allGroups.get(i)).getName().toString();
                buffer.append("<OPTION value='addNode:" + groupName + "'>" + groupName + "</OPTION>");
            }
            buffer.append("</SELECT></td></tr>");
            buffer.append("<tr><td colspan=\"2\"><b>Show Whole Lattice</b></td><td colspan=\"1\"><input type='checkbox' name='showLattice'></td></tr>\n");
            buffer.append("\n<tr><td colspan=\"1\">");
            buffer.append("<b>Add Parent:</b></td>");
            buffer.append("<td colspan=\"1\"><b>Add Child:</b></td><td colspan=\"1\"><b>Groups</b></td></tr>");
            for (i = 0; i < allGroups.size(); ++i) {
                groupName = ((LatticeNode)allGroups.get(i)).getName().toString();
                buffer.append("\n<tr>");
                buffer.append("<td width=7 align='center'><input type='checkbox' name='Lattice' value=\"Parent:" + groupName + "~Type:Add\"></td>");
                buffer.append("<td width=7 align='center'><input type='checkbox' name='Lattice' value=\"Child:" + groupName + "~Type:Add\"></td>");
                buffer.append("<td>" + groupName + "</td>");
                buffer.append("</tr>");
            }
            return buffer.toString();
        }
        catch (IOException e) {
            throw new MraldException(e.getMessage());
        }
    }

    public String getDeleteGroups(String keyGroup) {
        try {
            StringBuffer buffer = new StringBuffer();
            ArrayList allGroups = (ArrayList)this.getAllGroups(keyGroup);
            buffer.append("<tr><td colspan=\"2\"><b>Select Groups to Delete: </b></td></tr>\n");
            for (int i = 0; i < allGroups.size(); ++i) {
                String groupName = ((LatticeNode)allGroups.get(i)).getName().toString();
                buffer.append("\n<tr>");
                buffer.append("<td width=7 align='center'><input type='checkbox' name='Lattice' value='deleteGroup:" + groupName + "~Type:Delete'></td>");
                buffer.append("<td>" + groupName + "</td>");
                buffer.append("</tr>");
            }
            return buffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List getAllGroups(String keyGroup) throws InsufficentGroupAccessException, NodeNotFoundException, NullLatticeNodeException, InvalidLatticeStructureException, MraldException, IOException {
        ArrayList allGroups = new ArrayList();
        LatticeTree newLattice = (LatticeTree)GraphUserLattice.getLattice();
        LatticeNode key = null;
        try {
            key = newLattice.searchTree(keyGroup);
        }
        catch (NodeNotFoundException e) {
            key = newLattice.getRootNode();
        }
        if (key != newLattice.getRootNode()) {
            LatticeTree childTree = new LatticeTree((LatticeNode)LatticeFunctions.getChildTree(key));
            if (childTree == null || childTree.getRootNode() == null) {
                throw new InsufficentGroupAccessException("You have insufficent privilidges to access this system. Please contact your system Administrator.");
            }
            allGroups = LatticeFunctions.getFlatLattice(childTree.getRootNode());
            List allGroupsSorted = LatticeFunctions.sort(allGroups);
            return allGroupsSorted;
        }
        LatticeTree childTree = new LatticeTree(Config.getLatticeFactory().copyNode(key));
        allGroups = LatticeFunctions.getFlatLattice(childTree.getRootNode());
        return allGroups;
    }

    public int doStartTag() throws JspException {
        try {
            this.init();
            HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
            String groupList = this.process(req);
            this.pageContext.getOut().print(groupList);
            return 0;
        }
        catch (NullPointerException e) {
            HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
            HttpServletResponse resp = (HttpServletResponse)this.pageContext.getResponse();
            try {
                resp.sendRedirect(Config.getProperty("BaseUrl") + "/LatticeLogin.jsp?pageurl=" + req.getRequestURL());
            }
            catch (IOException ie) {
                JspException se = new JspException(ie.getMessage());
                se.fillInStackTrace();
                throw se;
            }
        }
        catch (IOException e) {
            JspException se = new JspException(e.getMessage());
            se.fillInStackTrace();
            throw se;
        }
        return 0;
    }

    public String process(HttpServletRequest req) throws JspException {
        try {
            this.init();
            User user = (User)req.getSession().getAttribute(Config.getProperty("cookietag"));
            this.keyGroup = user.getGroup();
            String modify = req.getParameter("ModifyNode");
            StringBuffer groupList = new StringBuffer();
            groupList.append("\n<tr><th colspan=\"2\"></th></tr><td><b>Current COI:</b></td><td><b>" + this.keyGroup + "</b></td></tr>");
            if (modify.equals("Add")) {
                groupList.append(this.getAddGroups(this.keyGroup));
            } else if (modify.equals("Delete")) {
                groupList.append(this.getDeleteGroups(this.keyGroup));
            } else if (modify.equals("Delete Link")) {
                groupList.append(this.getDeleteLinks(this.keyGroup));
            } else if (modify.equals("Add Link")) {
                groupList.append(this.getAddLinkGroups(this.keyGroup));
            }
            return groupList.toString();
        }
        catch (MraldException e) {
            throw new JspException((Throwable)e);
        }
    }

    public void init() {
    }
}

