/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.analysis;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.mitre.mrald.analysis.AnalysisControllerException;
import org.mitre.mrald.analysis.AnalysisManager;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldOutFile;

public class AnalysisController
extends AbstractStep {
    protected static Vector keys = new Vector();
    protected static Properties currentClasses;
    protected static PropertyChangeListener pcl;
    protected static String propertyName;
    protected MsgObject messageObject = new MsgObject();

    public AnalysisController() {
        propertyName = "analysisProps";
    }

    public AnalysisController(MsgObject thisMessage) {
        propertyName = "analysisProps";
        this.messageObject = thisMessage;
    }

    public void execute(MsgObject msgObject) throws WorkflowStepException {
        if (currentClasses == null) {
            AnalysisController.init();
            Config.addPropertyChangeListener(pcl);
        }
        try {
            this.messageObject = msgObject;
            this.processAnalysis();
        }
        catch (AnalysisControllerException e) {
            msgObject.closeOut();
            MiscUtils.handleException(msgObject, e, true);
        }
    }

    protected static void init() {
        AnalysisController.loadProperties();
        pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AnalysisController.loadProperties();
            }
        };
    }

    protected static void loadProperties() {
        currentClasses = MiscUtils.loadProperties(Config.getProperty(propertyName));
        Enumeration<?> eKeys = currentClasses.propertyNames();
        while (eKeys.hasMoreElements()) {
            keys.add(eKeys.nextElement());
        }
    }

    public void processAnalysis() throws WorkflowStepException, AnalysisControllerException {
        String returnFormat = this.messageObject.getValue("Format")[0];
        AnalysisManager analysisType = this.castElement(returnFormat);
        analysisType.execute(this.messageObject);
    }

    protected AnalysisManager castElement(String currentName) throws AnalysisControllerException {
        try {
            String className = this.getElementType(currentName);
            if (className == null) {
                return null;
            }
            Class<?> classDefinition = Class.forName(className);
            AnalysisManager analysisType = (AnalysisManager)classDefinition.newInstance();
            return analysisType;
        }
        catch (InstantiationException wfe) {
            throw new AnalysisControllerException("InstantiationException" + wfe.getMessage());
        }
        catch (ClassNotFoundException cne) {
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "AnalysisControllerException in castElements: Class " + currentName + " not found.");
        }
        catch (IllegalAccessException iae) {
            throw new AnalysisControllerException("Illegal access exception: " + iae.getMessage());
        }
        return null;
    }

    protected String getElementType(String classType) throws AnalysisControllerException {
        for (int i = 0; i < keys.size(); ++i) {
            if (!classType.startsWith((String)keys.get(i))) continue;
            return (String)currentClasses.get(keys.get(i));
        }
        throw new NullPointerException("An class type of " + classType + " is not recognized.  Please check the class type in the form and the appropriate properties file.");
    }

    static {
        propertyName = "";
    }
}

