/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import org.mitre.mrald.analysis.AnalysisElement;
import org.mitre.mrald.analysis.AnalysisManagerException;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.parser.ParserElement;

public abstract class AnalysisManager
extends AbstractStep {
    protected MsgObject msg;
    protected ArrayList<AnalysisElement> sortedElements;
    protected String[] templateEntries;
    protected String dataFile;
    protected String templateFile;

    public void execute(MsgObject msgObject) throws WorkflowStepException {
        try {
            this.msg = msgObject;
            this.dataFile = msgObject.getValue("dataFile")[0];
            if (this.dataFile == null || this.dataFile.equals(null)) {
                throw new WorkflowStepException("No data file provided so no analysis can be performed");
            }
            this.orderElements(this.msg);
            this.templateFile = this.makeTemplateFile();
            this.performAnalysis(this.templateFile, this.dataFile);
            this.prepareHeaders(this.msg);
            this.displayResults();
            this.msg.closeOut();
        }
        catch (AnalysisManagerException ame) {
            throw new WorkflowStepException(ame.getMessage());
        }
    }

    protected abstract void prepareHeaders(MsgObject var1) throws AnalysisManagerException;

    protected abstract String makeTemplateFile() throws AnalysisManagerException;

    protected abstract void performAnalysis(String var1, String var2) throws AnalysisManagerException;

    protected abstract void displayResults() throws AnalysisManagerException;

    private void orderElements(MsgObject msgObject) {
        ArrayList<ParserElement> currentElements = msgObject.getWorkingObjects();
        this.sortedElements = new ArrayList();
        TreeMap<Integer, AnalysisElement> orderedTree = new TreeMap<Integer, AnalysisElement>();
        AnalysisElement current_ae = null;
        for (int i = 0; i < currentElements.size(); ++i) {
            current_ae = (AnalysisElement)currentElements.get(i);
            Integer sortedNum = new Integer(current_ae.getOrder());
            orderedTree.put(sortedNum, current_ae);
        }
        Collection sortedValues = orderedTree.values();
        Iterator it = sortedValues.iterator();
        while (it.hasNext()) {
            this.sortedElements.add((AnalysisElement)it.next());
        }
    }
}

