/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.analysis;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.mitre.mrald.analysis.AnalysisElement;
import org.mitre.mrald.analysis.AnalysisManager;
import org.mitre.mrald.analysis.AnalysisManagerException;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.MsgObjectException;

public abstract class MitreAnalysis
extends AnalysisManager {
    protected void prepareHeaders(MsgObject msg) throws AnalysisManagerException {
        try {
            msg.SetOutPrintWriter();
            msg.setContentType("text/plain");
            msg.setHeader("Content-Disposition", "inline;");
        }
        catch (MsgObjectException mge) {
            AnalysisManagerException aee = new AnalysisManagerException(mge.getMessage());
            throw aee;
        }
    }

    protected String makeTemplateFile() throws AnalysisManagerException {
        try {
            String fileLocation = this.msg.getUserId() + System.currentTimeMillis() + ".template";
            FileOutputStream fout = new FileOutputStream(new File(System.getProperty("java.io.tmpdir") + "/" + fileLocation));
            AnalysisElement currentElement = null;
            for (int k = 0; k < this.sortedElements.size(); ++k) {
                currentElement = (AnalysisElement)this.sortedElements.get(k);
                String formattedString = "";
                if (currentElement.getType().equals("Nominal")) {
                    formattedString = currentElement.getField() + ": nominal ";
                    formattedString = formattedString + currentElement.getValues().length + "\n";
                } else if (currentElement.getType().equals("Continuous")) {
                    formattedString = currentElement.getField() + ": continuous\n";
                } else if (currentElement.getType().equals("Ordered")) {
                    formattedString = currentElement.getField() + ": ordered\n";
                } else if (currentElement.getType().equals("Ignore")) {
                    formattedString = currentElement.getField() + ": ignore\n";
                }
                fout.write(formattedString.getBytes());
            }
            fout.close();
            return System.getProperty("java.io.tmpdir") + "/" + fileLocation;
        }
        catch (FileNotFoundException fnfe) {
            throw new AnalysisManagerException(fnfe);
        }
        catch (IOException ioe) {
            throw new AnalysisManagerException(ioe);
        }
    }

    protected abstract void performAnalysis(String var1, String var2) throws AnalysisManagerException;

    protected abstract void displayResults() throws AnalysisManagerException;
}

