/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.analysis;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import org.mitre.mrald.analysis.AnalysisManagerException;
import org.mitre.mrald.analysis.WekaAnalysis;
import weka.classifiers.trees.Id3;
import weka.core.Instances;

public class WekaID3
extends WekaAnalysis {
    protected Id3 scheme;

    protected void performAnalysis(String template_file, String data_file) throws AnalysisManagerException {
        try {
            this.scheme = new Id3();
            SequenceInputStream sis = new SequenceInputStream(new FileInputStream(template_file), new FileInputStream(data_file));
            Instances data = new Instances((Reader)new InputStreamReader(sis));
            data.setClassIndex(Integer.parseInt(this.msg.getValue("focused_field")[0]));
            this.scheme.buildClassifier(data);
        }
        catch (FileNotFoundException fnfe) {
            throw new AnalysisManagerException(fnfe);
        }
        catch (IOException ioe) {
            ioe.fillInStackTrace();
            throw new AnalysisManagerException(ioe);
        }
        catch (Exception e) {
            throw new AnalysisManagerException(e);
        }
    }

    protected void displayResults() throws AnalysisManagerException {
        try {
            PrintWriter out = this.msg.getOutPrintWriter();
            out.println(this.scheme.toString());
        }
        catch (Exception e) {
            throw new AnalysisManagerException(e);
        }
    }
}

