/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.ddlbuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.ddlelements.DdlElementComparator;
import org.mitre.mrald.ddlelements.EmptyInsertElement;
import org.mitre.mrald.ddlelements.InsertElement;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.util.MraldException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertBuilder
extends AbstractStep {
    MsgObject msg;

    public String[] buildDdl(List<InsertElement> insertElements) throws MraldException {
        String ddl;
        ArrayList<String> returnDdl = new ArrayList<String>();
        ArrayList<InsertElement> elements = new ArrayList<InsertElement>();
        ArrayList<InsertElement> commonElements = new ArrayList<InsertElement>();
        String tableName = "";
        Iterator<InsertElement> iter = insertElements.iterator();
        for (int i = 0; i < insertElements.size(); ++i) {
            InsertElement currentElement = iter.next();
            if (currentElement.getTable().equals("!All")) {
                commonElements.add(currentElement);
                continue;
            }
            if (!tableName.equals(currentElement.getTable())) {
                tableName = currentElement.getTable();
                if (elements.size() == 0) {
                    elements.add(currentElement);
                    continue;
                }
                elements.addAll(commonElements);
                ddl = this.constructSingleDdl(elements);
                returnDdl.add(ddl);
                elements = new ArrayList();
            }
            elements.add(currentElement);
        }
        if (elements.size() > 0) {
            elements.addAll(commonElements);
            ddl = this.constructSingleDdl(elements);
            returnDdl.add(ddl);
        }
        if (returnDdl.size() == 0) {
            RuntimeException rte = new RuntimeException("No fields were chosen for insertion into any table.  No DDL statements were created. Try providing values for some fields and resubmit the request.");
            throw rte;
        }
        String[] returnArray = new String[returnDdl.size()];
        returnArray = returnDdl.toArray(returnArray);
        return returnArray;
    }

    public String constructSingleDdl(ArrayList elements) throws MraldException {
        ArrayList<String> fieldStrings = new ArrayList<String>();
        ArrayList<String> valueStrings = new ArrayList<String>();
        for (int i = 0; i < elements.size(); ++i) {
            InsertElement currentElement = (InsertElement)elements.get(i);
            fieldStrings = currentElement.buildFieldList(fieldStrings);
            valueStrings = currentElement.buildValueList(valueStrings);
        }
        String tableName = ((InsertElement)elements.get(0)).getTable();
        StringBuffer start = new StringBuffer();
        start.append("Insert into ");
        start.append(tableName);
        start.append(" ( ");
        StringBuffer end = new StringBuffer();
        end.append(" ) values ( ");
        for (int i = 0; i < fieldStrings.size(); ++i) {
            start.append(fieldStrings.get(i));
            end.append(valueStrings.get(i));
            if (i >= fieldStrings.size() - 1) continue;
            start.append(", ");
            end.append(", ");
        }
        end.append(" )");
        start.append(end);
        return start.toString();
    }

    @Override
    public void execute(MsgObject msgObject) throws WorkflowStepException {
        try {
            this.msg = msgObject;
            ArrayList<ParserElement> parserElements = msgObject.getWorkingObjects();
            List<InsertElement> c = this.extractInsertElements(parserElements);
            this.removeInvalidElements(c);
            Collections.sort(c, new DdlElementComparator());
            String[] ddl = this.buildDdl(c);
            for (int i = 0; i < ddl.length; ++i) {
                msgObject.setQuery(ddl[i]);
            }
        }
        catch (MraldException e) {
            throw new WorkflowStepException(e.getMessage());
        }
    }

    public List<InsertElement> extractInsertElements(ArrayList<ParserElement> parserElements) {
        ArrayList<InsertElement> returnList = new ArrayList<InsertElement>();
        for (int i = 0; i < parserElements.size(); ++i) {
            ParserElement nextElement = parserElements.get(i);
            if (!(nextElement instanceof InsertElement) || returnList.contains(nextElement)) continue;
            returnList.add((InsertElement)nextElement);
        }
        return returnList;
    }

    public void removeInvalidElements(Collection<InsertElement> c) throws MraldException {
        Iterator<InsertElement> iter = c.iterator();
        ArrayList<String> valueStrings = new ArrayList<String>();
        int lastSize = -1;
        while (iter.hasNext()) {
            InsertElement currentElement = iter.next();
            valueStrings = currentElement.buildValueList(valueStrings);
            if (valueStrings.size() == lastSize && !(currentElement instanceof EmptyInsertElement)) {
                iter.remove();
            }
            lastSize = valueStrings.size();
        }
    }
}

