/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.ddlelements;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.ddlelements.InsertElement;
import org.mitre.mrald.parser.MraldParserException;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldError;

public class InsertSequenceElement
extends InsertElement {
    private String datasource = null;
    private static final String QUERY = "select max(<:field:>)+1 from <:table:>";
    private static final String FIELD = "<:field:>";
    private static final String TABLE = "<:table:>";

    public String getElementType() {
        return "InsertSequenceElement";
    }

    public int getOffset() {
        if (!this.nameValues.getValue("Offset")[0].equals("")) {
            return Integer.parseInt(this.nameValues.getValue("Offset")[0]);
        }
        return 0;
    }

    public String getDatasource() {
        if (this.datasource == null) {
            this.datasource = this.nameValues.getValue("Datasource")[0];
            if (this.datasource.equals("")) {
                throw new RuntimeException("A datasource is required in order to get the next sequence number.  Please ask your system admin to make sure your InsertSequenceElement tag has a datasource provided.");
            }
        }
        return this.datasource;
    }

    public String getSequenceTable() {
        if (!this.nameValues.getValue("SequenceTable")[0].equals("")) {
            return this.nameValues.getValue("SequenceTable")[0];
        }
        return this.nameValues.getValue("Table")[0];
    }

    public String postProcess(MsgObject msg, String currentName) throws MraldParserException {
        String query = QUERY.replaceAll(FIELD, this.getField());
        query = query.replaceAll(TABLE, this.getSequenceTable());
        String value = null;
        try {
            MraldConnection conn = new MraldConnection(this.getDatasource(), msg);
            ResultSet rs = conn.executeQuery(query);
            if (rs.next()) {
                value = rs.getString(1);
                if (value == null || value.equals("null")) {
                    value = "1";
                }
            } else {
                throw new MraldParserException("Couldn't find a new sequence number for the " + this.getField() + " field of table " + this.getSequenceTable() + ".  No results from query: " + query);
            }
            int val = Integer.parseInt(value) + this.getOffset();
            value = new Integer(val).toString();
            this.nameValues.setValue("Value", value);
            rs.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new MraldError("Error trying to acquire a new sequence number for the " + this.getField() + " field of table " + this.getSequenceTable() + ".  No results from query: " + query, e, msg);
        }
        this.nameValues.setValue("Type", "Numeric");
        super.postProcess(msg, currentName);
        return currentName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InsertSequenceElement) {
            return o.hashCode() == this.hashCode();
        }
        return false;
    }
}

