/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.ddlelements;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.mitre.mrald.ddlelements.InsertElement;
import org.mitre.mrald.ddlelements.InsertSequenceElement;
import org.mitre.mrald.util.MraldException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSelectionElement
extends InsertElement {
    @Override
    public String getElementType() {
        return "MultiSelectionElement";
    }

    @Override
    public ArrayList<String> buildValueList(ArrayList<String> currentValueList) throws MraldException {
        try {
            String[] valueCheck = this.nameValues.getValue("Value");
            if (valueCheck[0].equals("")) {
                return currentValueList;
            }
            String typeCheck = this.nameValues.getValue("Type")[0];
            for (int i = 0; i < valueCheck.length; ++i) {
                String newValue;
                if (typeCheck.equals("String")) {
                    newValue = "'" + valueCheck[i] + "'";
                } else if (typeCheck.equals("Date") || typeCheck.equals("DateTime") || typeCheck.equals("Timestamp")) {
                    SimpleDateFormat df = new SimpleDateFormat("mm/dd/yyyy");
                    Date date = df.parse(valueCheck[i]);
                    df.applyPattern("yyyy-mm-dd");
                    String dateVal = df.format(date);
                    newValue = "'" + dateVal + "'";
                } else {
                    newValue = valueCheck[i];
                }
                currentValueList.add(newValue);
            }
            return currentValueList;
        }
        catch (ParseException e) {
            throw new MraldException(e.getMessage());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InsertSequenceElement) {
            return o.hashCode() == this.hashCode();
        }
        return false;
    }
}

