/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.formbuilder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.formbuilder.LinkElement;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.query.MraldDijkstra;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckFormJoinStructureStep
extends AbstractStep {
    MsgObject msg;

    public void setMsg(MsgObject msg) {
        this.msg = msg;
    }

    public MsgObject getMsg() {
        return this.msg;
    }

    public void convertLinks(MsgObject msgObject) {
        for (int i = 0; i < msgObject.getWorkingObjects().size(); ++i) {
            LinkElement currentElement;
            ParserElement currentObject = msgObject.getWorkingObjects().get(i);
            if (!(currentObject instanceof LinkElement) || (currentElement = (LinkElement)currentObject).ignore()) continue;
            msgObject.addLink(currentElement);
        }
        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "CheckFormJoinStructure: Convert Links: New MSG Object:no of links " + msgObject.getLinks().size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(MsgObject msg) throws WorkflowStepException {
        this.msg = msg;
        try {
            HashMap<String, ArrayList<ParserElement>> sortedElements = ParserElement.orderElements(msg.getWorkingObjects());
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "CheckFormJoinStructure: No of threads sorted " + sortedElements.size());
            for (ArrayList<ParserElement> sortedElems : sortedElements.values()) {
                MraldDijkstra joins;
                int joinValidity;
                MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "CheckFormJoinStructure: Next");
                for (ParserElement parseElem : sortedElems) {
                    MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "CheckFormJoinStructure: ElementType" + parseElem.getElementType() + "Thread Number " + parseElem.getThreadNumber());
                }
                MsgObject newMsg = new MsgObject();
                newMsg.setWorkingObjects(sortedElems);
                this.convertLinks(newMsg);
                ArrayList<String> tables = this.reapTables(newMsg);
                MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "CheckFormJoinStructure: NO OF TABLES: " + tables.size());
                if (tables.size() == 0 || (joinValidity = (joins = new MraldDijkstra(newMsg)).testJoinPath(tables)) == 0) continue;
                try {
                    msg.setRedirect("badForm.jsp?errorCode=" + joinValidity);
                }
                catch (IOException e) {
                    throw new MraldError(e, msg);
                    return;
                }
            }
        }
        catch (MraldException e) {
            throw new MraldError(e, msg);
        }
    }

    public ArrayList<String> reapTables(MsgObject msgObject) {
        ArrayList<String> tables = new ArrayList<String>();
        for (int i = 0; i < msgObject.getWorkingObjects().size(); ++i) {
            ParserElement currentElement = msgObject.getWorkingObjects().get(i);
            String newTable = currentElement.getNameValues().getValue("Table")[0];
            if (newTable.equals("") || tables.contains(newTable)) continue;
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "CheckFormJoinStructure: reapTables : Adding " + newTable);
            tables.add(newTable);
        }
        return tables;
    }
}

