/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.formbuilder;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.formbuilder.FormBuilderElement;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;
import org.mitre.mrald.util.XSLTranslator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XmlFileBuilder
extends AbstractStep {
    String TITLE_TAG = "Title";
    Document document;
    MsgObject msg;
    Node root;

    public XmlFileBuilder() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MraldError(e);
        }
        this.document = builder.newDocument();
    }

    public static void outputXml(Document document, Result destination) throws MraldException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(document);
            transformer.transform(source, destination);
        }
        catch (TransformerConfigurationException tce) {
            throw new MraldException(tce);
        }
        catch (TransformerException te) {
            throw new MraldException(te);
        }
    }

    public void addRoot() {
        String formType = this.msg.getValue("formType")[0];
        if (formType == null || formType.equals("")) {
            formType = "Mrald";
        }
        this.root = this.document.createElement(formType + "Form");
        this.document.appendChild(this.root);
    }

    public void addFields() {
    }

    public Node addFormElementsNode() {
        Element formElementsNode = this.document.createElement("formElements");
        this.root.appendChild(formElementsNode);
        return formElementsNode;
    }

    public void addTitle() {
        String title = this.msg.getValue(this.TITLE_TAG)[0];
        Element titleElement = this.document.createElement("title");
        Text titleText = this.document.createTextNode(title);
        titleElement.appendChild(titleText);
        this.root.appendChild(titleElement);
    }

    public void addDatasource() {
        String[] datasources;
        for (String datasource : datasources = this.msg.getValue("Datasource")) {
            Element datasourceElement = this.document.createElement("datasource");
            Text datasourceText = this.document.createTextNode(datasource);
            datasourceElement.appendChild(datasourceText);
            this.root.appendChild(datasourceElement);
        }
    }

    public void addMultiDb() {
        String multiDb = this.msg.getValue("multiDb")[0];
        if (multiDb.equals("")) {
            return;
        }
        Element multiDbElement = this.document.createElement("multiDb");
        Text multiDbText = this.document.createTextNode(multiDb);
        multiDbElement.appendChild(multiDbText);
        this.root.appendChild(multiDbElement);
    }

    public void execute(MsgObject _msg) throws WorkflowStepException {
        if (_msg.responseCommitted()) {
            return;
        }
        this.msg = _msg;
        this.addRoot();
        this.addTitle();
        this.addDatasource();
        this.addMultiDb();
        Node formElements = this.addFormElementsNode();
        this.addStats(formElements);
        Object[] elements = this.msg.getWorkingObjects().toArray();
        for (int i = 0; i < elements.length; ++i) {
            Node node = ((FormBuilderElement)elements[i]).getFBNode(this.document);
            if (node == null) continue;
            formElements.appendChild(node);
        }
        User user = (User)this.msg.getReq().getSession().getAttribute(Config.getProperty("cookietag"));
        if (user == null) {
            throw new MraldError("The user could not be found in the session.  Please pass this on to <a href=\"" + Config.getProperty("MAILTO") + "\">the system administrator.</a>  It is likely the session timeout in your webserver or servlet engine is set too low.", this.msg);
        }
        String userid = user.getEmail();
        String newformid = this.msg.getValue("formid")[0];
        String formType = this.msg.getValue("formType")[0];
        String formAccess = this.msg.getValue("formaccess")[0];
        if (newformid.equals("")) {
            newformid = Long.toString(System.currentTimeMillis());
        }
        if (formAccess.equals("")) {
            formAccess = "Personal";
        }
        if (formAccess.startsWith("Public")) {
            userid = "public";
        }
        String filename = userid + "_" + newformid + ".xml";
        File file = new File(Config.getProperty("customForms"), filename);
        StreamResult res = new StreamResult(file);
        try {
            XmlFileBuilder.outputXml(this.document, res);
        }
        catch (MraldException e) {
            throw new MraldError(e, this.msg);
        }
        File xslFile = new File(Config.getProperty("BasePath") + "/WEB-INF/extractor.xsl");
        StringBuffer newColumnNames = XSLTranslator.xslTransform(file, xslFile);
        Properties newProps = new Properties();
        ByteArrayInputStream stream = new ByteArrayInputStream(newColumnNames.toString().getBytes());
        try {
            newProps.load(stream);
        }
        catch (IOException ie) {
            throw new MraldError(ie, this.msg);
        }
        FBUtils.addColumnNames(newProps);
        try {
            this.msg.setRedirect(Config.getProperty("BaseUrl") + "/FormServer.jsp?formid=" + newformid + "&formType=" + formType + "&formAccess=" + formAccess);
        }
        catch (IOException ie) {
            throw new MraldError(ie, this.msg);
        }
    }

    protected void addStats(Node node) {
        Element statsElement = this.document.createElement("stat");
        statsElement.setAttribute("useStats", "yes");
        node.appendChild(statsElement);
    }
}

