/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import edu.berkeley.guir.prefuse.graph.DefaultEdge;
import edu.berkeley.guir.prefuse.graph.DefaultGraph;
import edu.berkeley.guir.prefuse.graph.DefaultNode;
import edu.berkeley.guir.prefuse.graph.DefaultTreeNode;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.io.AbstractGraphReader;
import edu.berkeley.guir.prefuse.graph.io.GraphReader;
import edu.berkeley.guir.prefuse.graph.io.XMLGraphReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.Link;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.TableMetaData;
import org.mitre.mrald.util.TypeUtils;

public class DBGraphReader
extends AbstractGraphReader
implements GraphReader {
    protected Class NODE_TYPE = DefaultNode.class;
    private String configFile = "";

    public Graph loadGraph(InputStream is) throws IOException {
        return this.loadGraph("temp");
    }

    public Graph loadGraph(String fileName) throws IOException {
        try {
            System.out.print("DBGraphReader: loadGraph: configFile: " + this.configFile);
            System.out.print("DBGraphReader: loadGraph: fileName: " + fileName);
            DBGraphHandler handler = new DBGraphHandler();
            return handler.getGraph(fileName);
        }
        catch (MraldException se) {
            se.printStackTrace();
            return null;
        }
    }

    public Graph loadGraph(URL urlFileName) throws IOException {
        try {
            System.out.print("DBGraphReader: loading Graph from URL");
            DBGraphHandler handler = new DBGraphHandler();
            return handler.getGraph(urlFileName);
        }
        catch (MraldException se) {
            se.printStackTrace();
            return null;
        }
    }

    public Graph loadGraph() throws IOException {
        try {
            System.out.print("DBGraphReader: loadGraph: configFile: " + this.configFile);
            System.out.print("DBGraphReader: loadGraph: no fileName ");
            DBGraphHandler handler = new DBGraphHandler();
            handler.init();
            return handler.getGraph();
        }
        catch (MraldException se) {
            se.printStackTrace();
            return null;
        }
    }

    public Class getNodeType() {
        return this.NODE_TYPE;
    }

    public void setNodeType(Class type) {
        this.NODE_TYPE = type;
    }

    public class DBGraphHandler {
        public static final String NODE = "node";
        public static final String EDGE = "edge";
        public static final String ATT = "att";
        public static final String TABLEID = "id";
        public static final String LABEL = "label";
        public static final String TYPE = "type";
        public static final String NAME = "name";
        public static final String VALUE = "value";
        public static final String LIST = "list";
        public static final String WEIGHT = "weight";
        public static final String GRAPH = "graph";
        public static final String DIRECTED = "directed";
        public static final String COLUMN = "column";
        private Graph m_graph = null;
        private HashMap<String, Node> m_nodeMap = new HashMap();
        private boolean m_directed = false;

        public void init() throws MraldException {
            System.out.print("DBGraphReader: init: configFile: " + DBGraphReader.this.configFile);
            int idx = -1;
            this.m_directed = idx >= 0;
            this.m_graph = new DefaultGraph(this.m_directed);
            this.loadDB();
            this.m_nodeMap.clear();
        }

        private void loadDB() throws MraldException {
            System.out.print("DBGraphReader: loadDB: configFile: " + DBGraphReader.this.configFile);
            String config_dir = DBGraphReader.this.configFile;
            if (Config.getFinalPropertiesLocation() == null) {
                Config.init(config_dir);
            }
            MetaData.reload();
        }

        public DBMetaData getDBMetaData() {
            return MetaData.getDbMetaData("main");
        }

        public Graph getGraph() throws MraldException {
            System.out.print("DBGraphReader: gettingGraph using DB ");
            DBMetaData dbmd = this.getDBMetaData();
            this.getNodes(dbmd);
            this.getEdges(dbmd);
            return this.m_graph;
        }

        public Graph getGraph(DBMetaData dbmd) throws MraldException {
            System.out.print("DBGraphReader: gettingGraph using DB ");
            this.getNodes(dbmd);
            this.getEdges(dbmd);
            return this.m_graph;
        }

        public Graph getGraph(URL urlFilename) throws MraldException {
            try {
                System.out.print("DBGraphReader: gettingGraph using url");
                InputStream inUrl = urlFilename.openStream();
                XMLGraphReader gr = new XMLGraphReader();
                gr.setNodeType(DefaultTreeNode.class);
                Graph graph = gr.loadGraph(inUrl);
                return graph;
            }
            catch (FileNotFoundException e) {
                throw new MraldException(e.getMessage());
            }
            catch (IOException e) {
                throw new MraldException(e.getMessage());
            }
        }

        public Graph getGraph(String filename) throws MraldException {
            try {
                System.out.print("DBGraphReader: gettingGraph using file " + filename);
                XMLGraphReader gr = new XMLGraphReader();
                gr.setNodeType(DefaultTreeNode.class);
                Graph graph = gr.loadGraph(filename);
                return graph;
            }
            catch (FileNotFoundException e) {
                throw new MraldException(e.getMessage());
            }
            catch (IOException e) {
                throw new MraldException(e.getMessage());
            }
        }

        public void getNodes(DBMetaData dbmd) throws MraldException {
            try {
                Collection<TableMetaData> tables = dbmd.getAllTableMetaData();
                Iterator<TableMetaData> tableIter = tables.iterator();
                HashMap keys = DBMetaData.setLinks(dbmd);
                while (tableIter.hasNext()) {
                    int fkeyCount = 0;
                    TableMetaData table = tableIter.next();
                    Node n = (Node)DBGraphReader.this.NODE_TYPE.newInstance();
                    n.setAttribute(TABLEID, table.getName());
                    this.m_nodeMap.put(table.getName(), n);
                    Collection<String> columns = table.getColumnNames();
                    Iterator<String> colIter = columns.iterator();
                    int i = 0;
                    while (colIter.hasNext()) {
                        boolean isFk;
                        String label = COLUMN + ++i;
                        String label2 = TYPE + i;
                        String fieldName = colIter.next().toString();
                        n.setAttribute(label, fieldName);
                        n.setAttribute(label2, TypeUtils.getSqlType(table.getFieldType(fieldName)));
                        boolean isPk = table.isPrimaryKey(fieldName);
                        if (isPk) {
                            n.setAttribute("pkey", fieldName);
                        }
                        if (!(isFk = DBMetaData.isFkey(table.getName(), fieldName, keys))) continue;
                        n.setAttribute("fkey" + ++fkeyCount, fieldName);
                    }
                    this.m_graph.addNode(n);
                    n.setAttribute(LABEL, table.getName());
                    n.setAttribute(WEIGHT, "0");
                }
            }
            catch (InstantiationException e) {
                throw new MraldException(e);
            }
            catch (IllegalAccessException e) {
                throw new MraldException(e);
            }
        }

        public void getEdges(DBMetaData dbmd) {
            Set links = dbmd.getLinkList();
            for (Link link : links) {
                String source = link.getPtable();
                String target = link.getFtable();
                Node s = this.m_nodeMap.get(source);
                Node t = this.m_nodeMap.get(target);
                DefaultEdge e = new DefaultEdge(s, t, this.m_directed);
                e.setAttribute(LABEL, link.getPcolumn());
                this.m_graph.addEdge((Edge)e);
            }
        }
    }
}

