/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.join;

import com.sun.rowset.CachedRowSetImpl;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Set;
import org.mitre.mrald.join.Join;
import org.mitre.mrald.join.PostgresSource;
import org.mitre.mrald.join.Source;
import org.mitre.mrald.util.HashMultiValueMap;
import org.mitre.mrald.util.KeySet;

public class HashJoin
extends Join {
    private HashMultiValueMap<KeySet, Integer> innerHash;

    public HashJoin(Source outerSource, Source innerSource, int[] outerCols, int[] innerCols) throws SQLException {
        super(outerSource, innerSource, outerCols, innerCols);
    }

    public ResultSet execute() throws SQLException {
        this.innerSource.estimateSize();
        this.innerHash = new HashMultiValueMap(this.innerSource.length);
        if (this.outerSource.db.getResultSetType() != 1003) {
            this.outerSource.db = this.outerSource.db.getConnection().createStatement(1003, 1007);
        }
        this.outerSource.db.setFetchSize(100);
        this.outerRS = this.outerSource.getResultSet();
        this.innerRS = this.innerSource.getResultSet();
        if (this.innerSource.db.getResultSetType() != 1004) {
            CachedRowSetImpl cache;
            try {
                cache = new CachedRowSetImpl();
            }
            catch (NullPointerException npe) {
                cache = new CachedRowSetImpl();
            }
            cache.populate(this.innerRS);
            this.innerRS.close();
            this.innerRS = cache;
        }
        this.populateHash();
        return new HashResultSet();
    }

    private void populateHash() throws SQLException {
        while (this.innerRS.next()) {
            KeySet key = new KeySet(this.innerRS, this.innerCols);
            this.innerHash.put(key, new Integer(this.innerRS.getRow()));
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Class.forName("org.postgresql.Driver");
        Connection db = DriverManager.getConnection("jdbc:postgresql://brainsrv2.mitre.org:5432/digests", "postgres", "postgres");
        Statement stmt1 = db.createStatement(1004, 1007);
        stmt1.execute("SET search_path TO ziph");
        String sql1 = "SELECT * FROM clusterstrategies";
        PostgresSource src1 = new PostgresSource(stmt1, sql1);
        int[] col1 = new int[]{1};
        Statement stmt2 = db.createStatement(1004, 1007);
        stmt2.execute("SET search_path TO ziph");
        String sql2 = "SELECT * FROM clustervalues";
        PostgresSource src2 = new PostgresSource(stmt2, sql2);
        int[] col2 = new int[]{3};
        HashJoin join = new HashJoin(src1, src2, col1, col2);
        ResultSet rs = join.execute();
        Source.print(rs);
        System.out.println("Done!");
    }

    private class HashResultSet
    extends Join.JoinResultSet {
        Iterator<Integer> values;

        public HashResultSet() throws SQLException {
            super(HashJoin.this);
            this.values = null;
        }

        protected boolean advanceCursor() throws SQLException {
            if (this.values != null && this.values.hasNext()) {
                this.advanceIterator();
            } else {
                if (!HashJoin.this.outerRS.next()) {
                    return false;
                }
                KeySet key = new KeySet(HashJoin.this.outerRS, HashJoin.this.outerCols);
                Set lookup = HashJoin.this.innerHash.getAll(key);
                this.values = lookup == null ? null : lookup.iterator();
                this.advanceIterator();
            }
            return true;
        }

        protected void advanceIterator() throws SQLException {
            HashJoin.this.innerRS.absolute(this.values == null ? -1 : this.values.next());
        }
    }
}

