/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.join;

import Zql.ParseException;
import Zql.ZConstant;
import Zql.ZExp;
import Zql.ZExpression;
import Zql.ZQuery;
import Zql.ZqlJJParser;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.mitre.mrald.join.Join;
import org.mitre.mrald.join.PostgresSource;
import org.mitre.mrald.join.Source;

public class IndexJoin
extends Join {
    public IndexJoin(Source outerSource, Source innerSource, int[] outerCols, int[] innerCols) throws SQLException {
        super(outerSource, innerSource, outerCols, innerCols);
    }

    public ResultSet execute() throws SQLException {
        if (this.outerSource.db.getResultSetType() != 1003) {
            this.outerSource.db = this.outerSource.db.getConnection().createStatement(1003, 1007);
        }
        this.outerSource.db.setFetchSize(100);
        this.outerRS = this.outerSource.getResultSet();
        try {
            String sql = this.innerSource.sql;
            if (!sql.contains(";")) {
                sql = sql + ";";
            }
            ZQuery query = new ZqlJJParser((Reader)new StringReader(sql)).QueryStatement();
            Vector selectCols = query.getSelect();
            ZExp whereClause = query.getWhere();
            if (whereClause == null) {
                whereClause = new ZConstant("TRUE", 2);
            }
            ZConstant placeHolder = new ZConstant("?", 2);
            ZExpression and = new ZExpression("AND", whereClause);
            for (int i = 0; i < this.innerCols.length; ++i) {
                int selectIndex = this.innerCols[i] - 1;
                String columnName = selectCols.get(selectIndex).toString();
                ZConstant column = new ZConstant(columnName, 0);
                ZExpression clause = new ZExpression("=", (ZExp)column, (ZExp)placeHolder);
                and.addOperand((ZExp)clause);
            }
            query.addWhere((ZExp)and);
            sql = this.innerSource.sql = query.toString();
            PreparedStatement db = this.innerSource.db.getConnection().prepareStatement(sql);
            this.innerSource.db = db;
            return new IndexResultSet(null, db.getMetaData());
        }
        catch (ParseException pe) {
            throw new SQLException(pe.getMessage());
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Class.forName("org.postgresql.Driver");
        Connection db = DriverManager.getConnection("jdbc:postgresql://brainsrv2.mitre.org:5432/digests", "postgres", "postgres");
        Statement stmt1 = db.createStatement(1004, 1007);
        stmt1.execute("SET search_path TO ziph");
        String sql1 = "SELECT cstrategy_id, description FROM clusterstrategies";
        PostgresSource src1 = new PostgresSource(stmt1, sql1);
        int[] col1 = new int[]{1};
        Statement stmt2 = db.createStatement(1004, 1007);
        stmt2.execute("SET search_path TO ziph");
        String sql2 = "SELECT cluster_id, num_clusters, cstrategy_id FROM clustervalues";
        PostgresSource src2 = new PostgresSource(stmt2, sql2);
        int[] col2 = new int[]{3};
        IndexJoin join = new IndexJoin(src1, src2, col1, col2);
        ResultSet rs = join.execute();
        System.out.println(src2.sql);
        Source.print(rs);
    }

    private class IndexResultSet
    extends Join.JoinResultSet {
        public IndexResultSet(ResultSetMetaData outer, ResultSetMetaData inner) throws SQLException {
            super(IndexJoin.this, outer, inner);
        }

        protected boolean testCursor() throws SQLException {
            return true;
        }

        protected boolean advanceCursor() throws SQLException {
            if (IndexJoin.this.innerRS != null && IndexJoin.this.innerRS.next()) {
                return true;
            }
            while (IndexJoin.this.outerRS.next()) {
                PreparedStatement db = (PreparedStatement)IndexJoin.this.innerSource.db;
                for (int i = 0; i < IndexJoin.this.outerCols.length; ++i) {
                    Object join = IndexJoin.this.outerRS.getObject(IndexJoin.this.outerCols[i]);
                    db.setObject(i + 1, join);
                }
                IndexJoin.this.innerRS = db.executeQuery();
                if (!IndexJoin.this.innerRS.next()) continue;
                return true;
            }
            return false;
        }
    }
}

