/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.join;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mitre.mrald.join.Source;

public class PostgresSource
extends Source {
    private static final Pattern explain = Pattern.compile("rows=(\\d+).*?width=(\\d+)");

    public PostgresSource(Statement db, String sql, int length, int width) {
        super(db, sql, length, width);
    }

    public PostgresSource(Statement db, String sql) {
        super(db, sql);
    }

    public void estimateSize() throws SQLException {
        Matcher m;
        if (this.length > 0 && this.width > 0) {
            return;
        }
        ResultSet rs = this.db.executeQuery("EXPLAIN " + this.sql);
        if (rs.next()) {
            String result = rs.getString(1);
            m = explain.matcher(result);
            if (!m.find()) {
                throw new SQLException("Unable to find estimates for " + this.sql);
            }
        } else {
            throw new SQLException("Unable to explain " + this.sql);
        }
        this.length = Integer.parseInt(m.group(1));
        this.width = Integer.parseInt(m.group(2));
    }

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Class.forName("org.postgresql.Driver");
        Connection db = DriverManager.getConnection("jdbc:postgresql://brainsrv2.mitre.org:5432/digests", "postgres", "postgres");
        Statement stmt = db.createStatement(1004, 1007);
        stmt.execute("SET search_path TO ziph");
        PostgresSource pg = new PostgresSource(stmt, "SELECT * FROM clustervalues");
        pg.estimateSize();
        System.out.println(pg.length + " rows");
        System.out.println(pg.width + " avg width");
    }
}

