/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.join;

import Zql.ParseException;
import Zql.ZQuery;
import Zql.ZqlJJParser;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Vector;
import org.mitre.mrald.join.HashJoin;
import org.mitre.mrald.join.IndexJoin;
import org.mitre.mrald.join.Join;
import org.mitre.mrald.join.NestedLoopJoin;
import org.mitre.mrald.join.SortMergeJoin;
import org.mitre.mrald.join.Source;

public class SimpleOptimizer {
    public static Join chooseJoinAlgorithm(Source one, Source two, int[] col1, int[] col2, boolean useIndex) throws ParseException, SQLException {
        int[] largeC;
        long memSize = Runtime.getRuntime().freeMemory();
        one.estimateSize();
        long size1 = one.length * one.width;
        two.estimateSize();
        long size2 = two.length * two.width;
        Source small = size1 < size2 ? one : two;
        int[] smallC = size1 < size2 ? col1 : col2;
        Source large = size1 < size2 ? two : one;
        int[] nArray = largeC = size1 < size2 ? col2 : col1;
        if (Math.min(size1, size2) < memSize) {
            if (SimpleOptimizer.noOrder(one.sql) && SimpleOptimizer.noOrder(two.sql)) {
                return new SortMergeJoin(large, small, largeC, smallC);
            }
            return new HashJoin(large, small, largeC, smallC);
        }
        if (useIndex) {
            return new IndexJoin(small, large, smallC, largeC);
        }
        return new NestedLoopJoin(large, small, largeC, smallC);
    }

    private static boolean noOrder(String sql) throws ParseException {
        ZQuery query;
        Vector orderCols;
        if (!sql.contains(";")) {
            sql = sql + ";";
        }
        return (orderCols = (query = new ZqlJJParser((Reader)new StringReader(sql)).QueryStatement()).getOrderBy()) == null || orderCols.size() == 0;
    }

    public static void main(String[] args) {
    }
}

