/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.output;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.MsgObjectException;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.output.OutputManagerException;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldOutFile;

public class DdlOutput
extends AbstractStep {
    Hashtable<String, String> failMessages = new Hashtable();
    MsgObject msg;
    boolean success;

    public void setMsg(MsgObject msg) {
        this.msg = msg;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void execute(MsgObject msg) throws WorkflowStepException {
        try {
            this.msg = msg;
            msg.SetOutPrintWriter();
            this.runDdl(msg.getUserUrl());
            this.sendFeedback();
        }
        catch (OutputManagerException e) {
            throw new WorkflowStepException(e);
        }
        catch (IOException e) {
            throw new WorkflowStepException(e);
        }
        catch (MsgObjectException e) {
            throw new WorkflowStepException(e);
        }
    }

    public int runDdl(String userID) throws OutputManagerException {
        ArrayList<String> failures;
        try {
            int iterCount;
            String datasource = this.msg.getValue("Datasource")[0];
            if (datasource.equals("")) {
                datasource = "main";
            }
            MraldConnection conn = new MraldConnection(datasource, this.msg);
            conn.setAutoCommit(false);
            failures = new ArrayList<String>(Arrays.asList(this.msg.getQuery()));
            ArrayList<String> ddl = failures;
            int lastNumFailed = 0;
            for (iterCount = 0; failures.size() > 0 && failures.size() != lastNumFailed && iterCount < 5 && iterCount <= 5; ++iterCount) {
                lastNumFailed = failures.size();
                ddl = failures;
                failures = new ArrayList();
                for (int i = 0; i < ddl.size(); ++i) {
                    String query = ddl.get(i);
                    try {
                        StringBuffer logInfo = new StringBuffer();
                        long startTime = MiscUtils.logQuery(userID, datasource, query, logInfo);
                        conn.executeUpdate(query);
                        MiscUtils.logQueryRun(startTime, logInfo);
                        continue;
                    }
                    catch (SQLException sqle) {
                        failures.add(query);
                        MraldOutFile.logToFile(sqle);
                        this.failMessages.put("Iteration " + iterCount + ", query " + i + " failed: " + query, sqle.getMessage());
                    }
                }
            }
            boolean bl = this.success = failures.size() == 0;
            if (this.success && iterCount < 100) {
                conn.commit();
            } else {
                conn.rollback();
            }
            conn.close();
        }
        catch (SQLException e) {
            throw new OutputManagerException(e);
        }
        return failures.size();
    }

    public void sendFeedback() throws IOException {
        String redirectURL;
        if (this.success) {
            String urlToGet = "SuccessUrl";
            redirectURL = this.msg.getValue(urlToGet)[0];
            if (redirectURL.equals("")) {
                redirectURL = "success.jsp";
            }
        } else {
            String urlToGet = "FailureUrl";
            Enumeration<String> e = this.failMessages.keys();
            while (e.hasMoreElements()) {
                String query = e.nextElement();
                MraldOutFile.appendToFile(query + " | " + this.failMessages.get(query).toString());
            }
            redirectURL = this.msg.getValue(urlToGet)[0];
            if (redirectURL.equals("")) {
                redirectURL = "failure.jsp";
            }
        }
        this.msg.setRedirect(redirectURL);
    }
}

